/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jiucai.appframework.common.util.BaseUtil;

public class LocalIPUtil
extends BaseUtil {
    public static void main(String[] args) {
        String serverIP = LocalIPUtil.getLocalIP();
        System.out.println("LocalIP : " + serverIP);
    }

    public static boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("windows") > -1) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    private static String getNetworkInterface(NetworkInterface ni) {
        String ipValue = "";
        InetAddress ip = null;
        if (null == ni) {
            return ipValue;
        }
        try {
            if (ni.isLoopback() || ni.isVirtual() || !ni.isUp()) {
                return ipValue;
            }
            Enumeration<InetAddress> addrEnum = ni.getInetAddresses();
            while (addrEnum.hasMoreElements()) {
                ip = addrEnum.nextElement();
                log.debug("HostName: " + ip.getHostName() + " HostAddress: " + ip.getHostAddress());
                if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                break;
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6 HostName[" + ip.getHostName() + "] IP\u5931\u8d25: " + ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        if (null != ip) {
            ipValue = ip.getHostAddress();
        }
        return ipValue;
    }

    public static String getIpByNetworkInterfaceName(String networkInterfaceName) {
        String ipValue = "";
        try {
            NetworkInterface ni = NetworkInterface.getByName(networkInterfaceName);
            ipValue = LocalIPUtil.getNetworkInterface(ni);
        }
        catch (SocketException e) {
            log.error("\u83b7\u53d6 NetworkInterface[" + networkInterfaceName + "] IP\u5931\u8d25: " + ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        return ipValue;
    }

    public static String getLocalIP() {
        String ipValue;
        block6: {
            ipValue = "";
            try {
                if (LocalIPUtil.isWindowsOS()) {
                    InetAddress addr = InetAddress.getLocalHost();
                    if (null != addr) {
                        ipValue = addr.getHostAddress();
                    }
                    break block6;
                }
                boolean bFindIP = false;
                ipValue = LocalIPUtil.getIpByNetworkInterfaceName("eth0");
                log.debug("eth0: " + ipValue);
                if (StringUtils.isBlank((String)ipValue)) {
                    ipValue = LocalIPUtil.getIpByNetworkInterfaceName("eth1");
                    log.debug("eth1: " + ipValue);
                    break block6;
                }
                if (!StringUtils.isBlank((String)ipValue)) break block6;
                Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
                while (netInterfaces.hasMoreElements() && !bFindIP) {
                    NetworkInterface ni = netInterfaces.nextElement();
                    log.debug("NetworkInterface Name: " + ni.getName());
                    if (null == ni || !StringUtils.isNotBlank((String)(ipValue = LocalIPUtil.getNetworkInterface(ni)))) continue;
                    bFindIP = true;
                    log.debug(ni.getName() + ": " + ipValue);
                    break;
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u672c\u673aIP\u5931\u8d25: " + ExceptionUtils.getFullStackTrace((Throwable)e));
            }
        }
        return ipValue;
    }
}

