/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.listener;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.jiucai.appframework.base.util.IpUtil;
import org.jiucai.appframework.common.util.LogUtil;
import org.jiucai.appframework.common.util.Logs;
import org.slf4j.impl.Log4jMDCAdapter;
import org.slf4j.spi.MDCAdapter;

public class AppLogListener
implements ServletRequestListener {
    protected MDCAdapter adapter;
    protected Logs log = LogUtil.getLog(this.getClass());

    public AppLogListener() {
        this.log.info("AppLogListener inited.");
        this.adapter = new Log4jMDCAdapter();
    }

    public void requestInitialized(ServletRequestEvent event) {
        HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
        String ip = IpUtil.getIp(request);
        this.adapter.put("ip", ip);
    }

    public void requestDestroyed(ServletRequestEvent event) {
        this.adapter.remove("ip");
    }
}

