/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.spring.web.render;

import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.jiucai.appframework.base.spring.web.render.BaseRender;
import org.springframework.stereotype.Service;

@Service(value="jsonRender")
public class JsonRender
extends BaseRender {
    private String encoding;
    private static ObjectMapper mapper = new ObjectMapper();

    public JsonRender() {
    }

    public JsonRender(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public ObjectMapper getObjectMapper() {
        return mapper;
    }

    @Override
    public String getContentType() {
        return "application/json; charset=" + this.encoding;
    }

    @Override
    public String getString(Object data) throws Exception {
        String result = null;
        result = mapper.writeValueAsString(data);
        return result;
    }

    static {
        mapper.configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, false);
        mapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, false);
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.configure(SerializationConfig.Feature.WRITE_NULL_MAP_VALUES, false);
    }
}

