/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.service.impl;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.jiucai.appframework.base.service.impl.AbstractBaseService;
import org.jiucai.appframework.base.util.ConfigUtil;
import org.jiucai.appframework.base.web.render.JsonRender;
import org.jiucai.appframework.base.web.render.XmlRender;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DefaultAppBaseService
extends AbstractBaseService {
    protected static String encoding = "UTF-8";
    @Autowired
    private XmlRender xmlRender;
    @Autowired
    private JsonRender jsonRender;
    protected static Configuration config = ConfigUtil.addConfig("config");

    public static Configuration getConfig() {
        return config;
    }

    public XmlRender getXmlRender() {
        this.xmlRender.setEncoding(encoding);
        return this.xmlRender;
    }

    public JsonRender getJsonRender() {
        this.jsonRender.setEncoding(encoding);
        this.jsonRender.getObjectMapper().getDeserializationConfig().without(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
        this.jsonRender.getObjectMapper().getSerializationConfig().without(new SerializationConfig.Feature[]{SerializationConfig.Feature.WRAP_ROOT_VALUE});
        this.jsonRender.getObjectMapper().getSerializationConfig().without(new SerializationConfig.Feature[]{SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS});
        this.jsonRender.getObjectMapper().getSerializationConfig().without(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT});
        this.jsonRender.getObjectMapper().getSerializationConfig().without(new SerializationConfig.Feature[]{SerializationConfig.Feature.WRITE_NULL_MAP_VALUES});
        SerializationConfig sConfig = this.jsonRender.getObjectMapper().getSerializationConfig().withSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        this.jsonRender.getObjectMapper().setSerializationConfig(sConfig);
        return this.jsonRender;
    }

    protected String getJsonMsg(Boolean isSuccess, String msg) {
        StringBuffer result = new StringBuffer("");
        if (isSuccess.booleanValue()) {
            if (StringUtils.isBlank((String)msg)) {
                msg = "ok";
            }
            result.append("{\"success\":\"").append(msg).append("\"}");
        } else {
            if (StringUtils.isBlank((String)msg)) {
                msg = "failed";
            }
            result.append("{\"error\":\"").append(msg).append("\"}");
        }
        return result.toString();
    }

    protected String getXmlMsg(Boolean isSuccess, String msg) {
        StringBuffer result = new StringBuffer("");
        if (isSuccess.booleanValue()) {
            if (StringUtils.isBlank((String)msg)) {
                msg = "ok";
            }
            result.append("<chart><success>").append(msg).append("</success></chart>");
        } else {
            if (StringUtils.isBlank((String)msg)) {
                msg = "failed";
            }
            result.append("<chart><error>").append(msg).append("</error></chart>");
        }
        return result.toString();
    }

    @Override
    public String getContentType() {
        return this.getJsonRender().getContentType();
    }

    static {
        config = ConfigUtil.addConfig("mail");
    }
}

