/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.util;

import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.jiucai.appframework.common.util.BaseUtil;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeUtil
extends BaseUtil {
    protected static final String DEFAULT_PATTERN = "yyyy-MM-dd";
    protected static final Locale DEFAULT_LOCALE = Locale.SIMPLIFIED_CHINESE;
    protected static final DateTimeZone DEFAULT_TIMEZONE = DateTimeZone.forOffsetHours((int)8);

    public static DateTimeFormatter getDateTimeFormatter(String pattern) {
        return DateTimeFormat.forPattern((String)pattern).withZone(DEFAULT_TIMEZONE).withLocale(DEFAULT_LOCALE);
    }

    public static DateTime parseDateTime(String date, String pattern) {
        DateTime dt = DateTimeUtil.getDateTimeFormatter(pattern).parseDateTime(date);
        return dt;
    }

    public static DateTime getDateTime(Date date) {
        return new DateTime(date.getTime(), DEFAULT_TIMEZONE);
    }

    public static String getFormatedDateTime(DateTime dt, String pattern) {
        return dt.toString(pattern, DEFAULT_LOCALE);
    }

    public static String getFormatedDate(Date date, String pattern) {
        return DateTimeUtil.getDateTime(date).toString(pattern, DEFAULT_LOCALE);
    }

    public static String getFormatedDate(int days, String pattern) {
        String formatPattern = DEFAULT_PATTERN;
        if (StringUtils.isNotBlank((String)pattern)) {
            formatPattern = pattern;
        }
        return DateTimeUtil.getDateTime(new Date()).plusDays(days).toString(formatPattern);
    }

    public static String getYearMonth(Date date) {
        return DateTimeUtil.getFormatedDate(date, "yyyyMM");
    }

    public static String getYearWeek(Date date) {
        return DateTimeUtil.getFormatedDate(date, "xxxxww");
    }

    public static DateTime getDateTimeFromYearWeek(String yearWeek) {
        DateTime dt = DateTimeUtil.parseDateTime(yearWeek, "xxxxww");
        return dt;
    }

    public static String getCurrentTime() {
        return DateTimeUtil.getFormatedDate(new Date(), "yyyy-MM-dd HH:mm:ss");
    }

    public static Date getCurrentDate() {
        return DateTime.now().toDate();
    }

    public static DateTime getCurrentDateTime() {
        return DateTime.now();
    }
}

