/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    public static final String CHARSET_UTF8 = "UTF-8";
    protected static Log logger = LogFactory.getLog(HttpClientUtil.class);
    private static ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

        public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                Charset charset = ContentType.getOrDefault((HttpEntity)entity).getCharset();
                if (null != charset) {
                    return new String(EntityUtils.toByteArray((HttpEntity)entity), charset);
                }
                return new String(EntityUtils.toByteArray((HttpEntity)entity));
            }
            return null;
        }
    };

    public static String get(String url) {
        return HttpClientUtil.get(url, null, null);
    }

    public static String get(String url, Map<String, String> params) {
        return HttpClientUtil.get(url, params, null);
    }

    public static String get(String url, Map<String, String> params, String charset) {
        if (url == null || StringUtils.isEmpty((String)url)) {
            return null;
        }
        List<NameValuePair> qparams = HttpClientUtil.getParamsList(params);
        if (qparams != null && qparams.size() > 0) {
            charset = charset == null ? CHARSET_UTF8 : charset;
            String formatParams = URLEncodedUtils.format(qparams, (String)charset);
            url = url.indexOf("?") < 0 ? url + "?" + formatParams : url.substring(0, url.indexOf("?") + 1) + formatParams;
        }
        CloseableHttpClient httpclient = HttpClientUtil.getHttpClient(charset);
        HttpGet hg = new HttpGet(url);
        String responseStr = null;
        try {
            responseStr = (String)httpclient.execute((HttpUriRequest)hg, responseHandler);
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException("\u5ba2\u6237\u7aef\u8fde\u63a5\u534f\u8bae\u9519\u8bef", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO\u64cd\u4f5c\u5f02\u5e38", e);
        }
        finally {
            HttpClientUtil.abortConnection((HttpUriRequest)hg, httpclient);
        }
        return responseStr;
    }

    public static String post(String url, Map<String, String> params) {
        return HttpClientUtil.post(url, params, CHARSET_UTF8);
    }

    public static String post(String url, Map<String, String> params, String charset) {
        if (url == null || StringUtils.isEmpty((String)url)) {
            return null;
        }
        CloseableHttpClient httpclient = HttpClientUtil.getHttpClient(charset);
        UrlEncodedFormEntity formEntity = null;
        try {
            formEntity = charset == null || StringUtils.isEmpty((String)charset) ? new UrlEncodedFormEntity(HttpClientUtil.getParamsList(params)) : new UrlEncodedFormEntity(HttpClientUtil.getParamsList(params), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7f16\u7801\u96c6", e);
        }
        HttpPost hp = new HttpPost(url);
        hp.setEntity((HttpEntity)formEntity);
        String responseStr = null;
        try {
            responseStr = (String)httpclient.execute((HttpUriRequest)hp, responseHandler);
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException("\u5ba2\u6237\u7aef\u8fde\u63a5\u534f\u8bae\u9519\u8bef", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO\u64cd\u4f5c\u5f02\u5e38", e);
        }
        finally {
            HttpClientUtil.abortConnection((HttpUriRequest)hp, httpclient);
        }
        return responseStr;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String post(String url, Map<String, String> params, String charset, URL keystoreUrl, String keystorePassword) {
        if (url == null) return null;
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        UrlEncodedFormEntity formEntity = null;
        try {
            formEntity = charset == null || StringUtils.isEmpty((String)charset) ? new UrlEncodedFormEntity(HttpClientUtil.getParamsList(params)) : new UrlEncodedFormEntity(HttpClientUtil.getParamsList(params), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7f16\u7801\u96c6", e);
        }
        CloseableHttpClient httpclient = null;
        HttpPost hp = null;
        String responseStr = null;
        try {
            KeyStore keyStore = HttpClientUtil.createKeyStore(keystoreUrl, keystorePassword);
            HttpClientBuilder builder = HttpClientUtil.getHttpClientBuilder(charset);
            TrustStrategy trustStrategy = new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            };
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(keyStore, trustStrategy).build();
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext);
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
            httpclient = builder.build();
            hp = new HttpPost(url);
            hp.setEntity((HttpEntity)formEntity);
            responseStr = (String)httpclient.execute((HttpUriRequest)hp, responseHandler);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                throw new RuntimeException("\u6307\u5b9a\u7684\u52a0\u5bc6\u7b97\u6cd5\u4e0d\u53ef\u7528", e);
                catch (KeyStoreException e2) {
                    throw new RuntimeException("keytore\u89e3\u6790\u5f02\u5e38", e2);
                }
                catch (CertificateException e3) {
                    throw new RuntimeException("\u4fe1\u4efb\u8bc1\u4e66\u8fc7\u671f\u6216\u89e3\u6790\u5f02\u5e38", e3);
                }
                catch (FileNotFoundException e4) {
                    throw new RuntimeException("keystore\u6587\u4ef6\u4e0d\u5b58\u5728", e4);
                }
                catch (IOException e5) {
                    throw new RuntimeException("I/O\u64cd\u4f5c\u5931\u8d25\u6216\u4e2d\u65ad ", e5);
                }
                catch (KeyManagementException e6) {
                    throw new RuntimeException("\u5904\u7406\u5bc6\u94a5\u7ba1\u7406\u7684\u64cd\u4f5c\u5f02\u5e38", e6);
                }
            }
            catch (Throwable throwable) {
                HttpClientUtil.abortConnection(hp, httpclient);
                throw throwable;
            }
        }
        HttpClientUtil.abortConnection((HttpUriRequest)hp, httpclient);
        return responseStr;
    }

    public static HttpClientConnectionManager getConnectionManager() {
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setMaxTotal(100);
        connManager.setDefaultMaxPerRoute(100);
        return connManager;
    }

    public static HttpClientBuilder getHttpClientBuilder(String charset) {
        HttpClientBuilder builder = HttpClients.custom();
        Charset chartset = charset == null ? Charset.forName(CHARSET_UTF8) : Charset.forName(charset);
        ConnectionConfig.Builder connBuilder = ConnectionConfig.custom().setCharset(chartset);
        RequestConfig.Builder reqBuilder = RequestConfig.custom();
        reqBuilder.setExpectContinueEnabled(false);
        reqBuilder.setSocketTimeout(600000);
        reqBuilder.setConnectTimeout(600000);
        DefaultServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy = new DefaultServiceUnavailableRetryStrategy(3, 3000);
        builder.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)serviceUnavailableRetryStrategy);
        builder.setUserAgent("Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1)");
        builder.setDefaultRequestConfig(reqBuilder.build());
        builder.setDefaultConnectionConfig(connBuilder.build());
        builder.setConnectionManager(HttpClientUtil.getConnectionManager());
        return builder;
    }

    public static CloseableHttpClient getHttpClient(String charset) {
        HttpClientBuilder builder = HttpClientUtil.getHttpClientBuilder(charset);
        CloseableHttpClient httpclient = builder.build();
        return httpclient;
    }

    private static void abortConnection(HttpUriRequest hrb, CloseableHttpClient httpclient) {
        if (hrb != null) {
            hrb.abort();
        }
        if (httpclient != null) {
            try {
                logger.info((Object)"closing httpclient ...");
                httpclient.close();
            }
            catch (IOException e) {
                logger.error((Object)"failed to close httpclient", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore createKeyStore(URL url, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("Keystore url may not be null");
        }
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream is = null;
        try {
            is = url.openStream();
            keystore.load(is, password != null ? password.toCharArray() : null);
        }
        finally {
            if (is != null) {
                is.close();
                is = null;
            }
        }
        return keystore;
    }

    private static List<NameValuePair> getParamsList(Map<String, String> paramsMap) {
        if (paramsMap == null || paramsMap.size() == 0) {
            return null;
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> map : paramsMap.entrySet()) {
            params.add((NameValuePair)new BasicNameValuePair(map.getKey(), map.getValue()));
        }
        return params;
    }
}

