/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.crypto;

import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jiucai.appframework.common.encrypt.AbstractEncryptor;

public class AES
extends AbstractEncryptor {
    protected static int keyLength = 256;
    protected static String algorithmKey = "AES";

    public static byte[] encrypt(String content, String password) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(algorithmKey);
            kgen.init(keyLength, new SecureRandom(password.getBytes(charsetName)));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, algorithmKey);
            Cipher cipher = Cipher.getInstance(algorithmKey);
            byte[] byteContent = content.getBytes(charsetName);
            cipher.init(1, key);
            byte[] result = cipher.doFinal(byteContent);
            return result;
        }
        catch (Throwable e) {
            log.error("encrypt failed", e);
            return null;
        }
    }

    public static byte[] decrypt(byte[] content, String password) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(algorithmKey);
            kgen.init(keyLength, new SecureRandom(password.getBytes(charsetName)));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, algorithmKey);
            Cipher cipher = Cipher.getInstance(algorithmKey);
            cipher.init(2, key);
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Throwable e) {
            log.error("decrypt failed", e);
            return null;
        }
    }

    public static String encode(String content, String password) {
        String result = null;
        byte[] encryptResult = AES.encrypt(content, password);
        if (null != encryptResult) {
            result = AES.byte2Hex(encryptResult);
        }
        return result;
    }

    public static String decode(String encryptResult, String password) {
        String result = null;
        byte[] decryptFrom = AES.hex2Byte(encryptResult);
        byte[] decryptResult = AES.decrypt(decryptFrom, password);
        if (null != decryptResult) {
            try {
                result = new String(decryptResult, charsetName);
            }
            catch (UnsupportedEncodingException e) {
                log.error("decode failed", e);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String content = "AES\u52a0\u5bc6\u5b57\u7b26\u4e32\u6d4b\u8bd5by-jiucai";
        String password = "123456789";
        System.out.println("\u52a0\u5bc6\u524d\uff1a" + content);
        String encodeStr = AES.encode(content, password);
        System.out.println("\u52a0\u5bc6\u540e\uff1a" + encodeStr);
        System.out.println("\u89e3\u5bc6\u540e\uff1a" + AES.decode(encodeStr, password));
    }
}

