/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.jiucai.appframework.common.util.BaseUtil;

public class ValueFormatUtil
extends BaseUtil {
    public static final String PERSENT_STR = "%";
    public static final String RMB_STR = "\uffe5";
    public static NumberFormat nf = NumberFormat.getInstance(Locale.CHINA);
    public static DecimalFormat df = new DecimalFormat("0.00");
    public static NumberFormat doubleFormater = new DecimalFormat("0.00");
    public static NumberFormat longFormater = new DecimalFormat("#");
    public static String nullValue = "-";

    @Deprecated
    public static String formatNumberString(Object val) {
        String result = ValueFormatUtil.convertMapValue(val);
        if (StringUtils.isNotEmpty((String)result)) {
            if (NumberUtils.toLong((String)result) > 0L) {
                result = longFormater.format(NumberUtils.toLong((String)result));
            } else if (NumberUtils.toDouble((String)result) > 0.0) {
                result = doubleFormater.format(NumberUtils.toDouble((String)result));
            }
        }
        return result;
    }

    @Deprecated
    public static String formatNullString(Object val) {
        String result = ValueFormatUtil.convertMapValue(val);
        if (StringUtils.isBlank((String)result) || "null".equalsIgnoreCase(result)) {
            result = nullValue;
        }
        return result;
    }

    public static void main(String[] args) {
        String money = ValueFormatUtil.getMoneyString(1.3356234234888324E13);
        System.out.println(money);
    }

    protected static NumberFormat getNumberFormat() {
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        nf.setGroupingUsed(false);
        return nf;
    }

    protected static DecimalFormat getDecimalFormat() {
        return df;
    }

    public static String getNoneString() {
        return "--";
    }

    public static String getIntegerString(Object data) {
        String result = ValueFormatUtil.convertMapValue(data);
        if (StringUtils.isNotBlank((String)result)) {
            return result;
        }
        return ValueFormatUtil.getNoneString();
    }

    public static String getDoubleString(Object data) {
        String result = ValueFormatUtil.convertMapValue(data);
        if (StringUtils.isNotBlank((String)result)) {
            result = ValueFormatUtil.getNumberFormat().format(NumberUtils.toDouble((String)result));
            return result;
        }
        return ValueFormatUtil.getNoneString();
    }

    public static String getMoneyString(Object data) {
        String result = ValueFormatUtil.convertMapValue(data);
        if (StringUtils.isNotBlank((String)result)) {
            result = ValueFormatUtil.getNumberFormat().format(NumberUtils.toDouble((String)result));
            return new StringBuffer("").append(RMB_STR).append(result).toString();
        }
        return ValueFormatUtil.getNoneString();
    }

    public static String getPersentString(Object data) {
        String result = ValueFormatUtil.convertMapValue(data);
        if (StringUtils.isNotBlank((String)result)) {
            result = ValueFormatUtil.getDecimalFormat().format(NumberUtils.toDouble((String)result) * 100.0);
            return new StringBuffer("").append(result).append(PERSENT_STR).toString();
        }
        return ValueFormatUtil.getNoneString();
    }

    public static String getHourString(String hour) {
        String dateTime = "";
        if (hour.equals("0")) {
            dateTime = "00:00-01:00";
        } else if (hour.equals("1")) {
            dateTime = "01:00-02:00";
        } else if (hour.equals("2")) {
            dateTime = "02:00-03:00";
        } else if (hour.equals("3")) {
            dateTime = "03:00-04:00";
        } else if (hour.equals("4")) {
            dateTime = "04:00-05:00";
        } else if (hour.equals("5")) {
            dateTime = "05:00-06:00";
        } else if (hour.equals("6")) {
            dateTime = "06:00-07:00";
        } else if (hour.equals("7")) {
            dateTime = "07:00-08:00";
        } else if (hour.equals("8")) {
            dateTime = "08:00-09:00";
        } else if (hour.equals("9")) {
            dateTime = "09:00-10:00";
        } else if (hour.equals("10")) {
            dateTime = "10:00-11:00";
        } else if (hour.equals("11")) {
            dateTime = "11:00-12:00";
        } else if (hour.equals("12")) {
            dateTime = "12:00-13:00";
        } else if (hour.equals("13")) {
            dateTime = "13:00-14:00";
        } else if (hour.equals("14")) {
            dateTime = "14:00-15:00";
        } else if (hour.equals("15")) {
            dateTime = "15:00-16:00";
        } else if (hour.equals("16")) {
            dateTime = "16:00-17:00";
        } else if (hour.equals("17")) {
            dateTime = "17:00-18:00";
        } else if (hour.equals("18")) {
            dateTime = "18:00-19:00";
        } else if (hour.equals("19")) {
            dateTime = "19:00-20:00";
        } else if (hour.equals("20")) {
            dateTime = "20:00-21:00";
        } else if (hour.equals("21")) {
            dateTime = "21:00-22:00";
        } else if (hour.equals("22")) {
            dateTime = "22:00-23:00";
        } else if (hour.equals("23")) {
            dateTime = "23:00-24:00";
        }
        return dateTime;
    }
}

