/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.jiucai.appframework.common.util.LogUtil;
import org.jiucai.appframework.common.util.Logs;

public class ZipFileUtil {
    protected static Logs logger = LogUtil.getLog(ZipFileUtil.class);
    public static final int BUFFER_SIZE = 4096;

    private static String getFilePath(File file) {
        String entryName = file.getPath();
        int index = entryName.indexOf(File.separator);
        if (index > 0) {
            entryName = entryName.substring(index + 1);
        }
        entryName = entryName.replace("\\", "/");
        return entryName;
    }

    private static String getDirectoryPath(File file) {
        String entryName = file.getAbsolutePath();
        int index = entryName.indexOf(File.separator);
        if (index > 0) {
            entryName = entryName.substring(index + 1);
        }
        entryName = entryName.replace("\\", "/");
        return entryName;
    }

    private static void addEntry(String zipEntryName, File file, ZipOutputStream zos, Boolean useSameDir) throws IOException {
        String entryName = zipEntryName;
        if (file.isDirectory()) {
            if (!useSameDir.booleanValue()) {
                entryName = ZipFileUtil.getDirectoryPath(file) + "/";
                logger.debug("add zip entry directory: " + entryName);
                zos.putNextEntry(new ZipEntry(entryName));
                File[] fl = file.listFiles();
                for (int i = 0; i < fl.length; ++i) {
                    ZipFileUtil.addEntry(entryName, fl[i], zos, useSameDir);
                }
            }
        } else {
            int len;
            byte[] buf = new byte[4096];
            FileInputStream in = new FileInputStream(file);
            entryName = useSameDir != false ? zipEntryName : ZipFileUtil.getFilePath(file);
            ZipEntry entry = new ZipEntry(entryName);
            entry.setTime(file.lastModified());
            logger.debug("add zip entry file: " + entryName);
            zos.putNextEntry(entry);
            while ((len = in.read(buf)) > 0) {
                zos.write(buf, 0, len);
            }
            in.close();
            zos.flush();
        }
        zos.closeEntry();
    }

    protected static void setZipOutputStream(ZipOutputStream zos, String encoding, String comment) {
        zos.setLevel(9);
        if (StringUtils.isNotBlank((String)encoding)) {
            zos.setEncoding(encoding);
        }
        if (StringUtils.isNotBlank((String)comment)) {
            zos.setComment(comment);
        }
    }

    public static Boolean zip(OutputStream out, List<String> entryNameList, List<String> fileList, String encoding, String comment, Boolean useSameDir) {
        Boolean isSuccess = false;
        try {
            ZipOutputStream zos = new ZipOutputStream(out);
            ZipFileUtil.setZipOutputStream(zos, encoding, comment);
            for (int i = 0; i < fileList.size(); ++i) {
                try {
                    String entryName = null;
                    if (null != entryNameList && entryNameList.size() > 0) {
                        entryName = entryNameList.get(i);
                    }
                    ZipFileUtil.addEntry(entryName, new File(fileList.get(i)), zos, useSameDir);
                    continue;
                }
                catch (Throwable e1) {
                    logger.error("add file " + fileList.get(i) + " to zip file failed: " + ExceptionUtils.getRootCauseMessage((Throwable)e1));
                }
            }
            zos.flush();
            zos.close();
            logger.debug("ZIP file content wireted to OutputStream successed.");
            isSuccess = true;
        }
        catch (IOException ex) {
            isSuccess = false;
            logger.error("failed to zip: ", ex);
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean zip(File zipfile, List<String> entryNameList, List<File> fileList, String encoding, String comment, Boolean useSameDir) {
        Boolean isSuccess = false;
        ZipOutputStream zos = null;
        try {
            if (zipfile.exists()) {
                zipfile.delete();
            }
            if (!zipfile.getParentFile().exists()) {
                zipfile.getParentFile().mkdirs();
            }
            zos = new ZipOutputStream((OutputStream)new FileOutputStream(zipfile));
            ZipFileUtil.setZipOutputStream(zos, encoding, comment);
            for (int i = 0; i < fileList.size(); ++i) {
                try {
                    String entryName = null;
                    if (null != entryNameList && entryNameList.size() > 0) {
                        entryName = entryNameList.get(i);
                    }
                    ZipFileUtil.addEntry(entryName, fileList.get(i), zos, useSameDir);
                    continue;
                }
                catch (Throwable e1) {
                    logger.error("add file " + fileList.get(i) + " to zip file failed: " + ExceptionUtils.getRootCauseMessage((Throwable)e1));
                }
            }
            zos.flush();
            logger.debug("ZIP file " + zipfile.getPath() + " created.");
            isSuccess = true;
        }
        catch (Throwable ex) {
            isSuccess = false;
            logger.error("failed to zip: ", ex);
        }
        finally {
            if (null != zos) {
                try {
                    zos.close();
                }
                catch (Throwable e) {
                    logger.error("Can not close ZipOutputStream: ", e);
                }
            }
        }
        return isSuccess;
    }

    public static Boolean zip(File zipfile, Map<String, File> fileListMap, String encoding, String comment, Boolean useSameDir) {
        List<String> entryNameList = Collections.synchronizedList(new LinkedList());
        List<File> fileList = Collections.synchronizedList(new LinkedList());
        for (Map.Entry<String, File> entry : fileListMap.entrySet()) {
            entryNameList.add(entry.getKey());
            fileList.add(entry.getValue());
        }
        return ZipFileUtil.zip(zipfile, entryNameList, fileList, encoding, comment, useSameDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> unzip(String zipFile, String encoding, String descDir) {
        List<String> fileList = Collections.synchronizedList(new ArrayList());
        ZipFile zf = null;
        try {
            zf = new ZipFile(new File(zipFile), encoding);
            Enumeration entries = zf.getEntries();
            File outPath = new File(descDir);
            if (!outPath.exists()) {
                outPath.mkdirs();
            }
            String outPathDir = descDir;
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                String entryName = entry.getName();
                String outFileName = "";
                if (entry.isDirectory()) {
                    logger.debug("[DIR ] creating " + entryName);
                    File decompressDirFile = new File(outPathDir + "/" + entryName);
                    if (!decompressDirFile.exists()) {
                        decompressDirFile.mkdirs();
                    }
                } else {
                    int len;
                    outFileName = outPathDir + "/" + entryName;
                    logger.debug("outFileName: " + outFileName);
                    FileOutputStream out = new FileOutputStream(outFileName);
                    logger.debug("[FILE] creating " + entryName + " [" + entry.getCompressedSize() + "/" + entry.getSize() + " bytes]");
                    byte[] buf1 = new byte[4096];
                    InputStream in = zf.getInputStream(entry);
                    while ((len = in.read(buf1)) > 0) {
                        ((OutputStream)out).write(buf1, 0, len);
                    }
                    in.close();
                    ((OutputStream)out).close();
                }
                if (!StringUtils.isNotBlank((String)outFileName)) continue;
                fileList.add(entryName);
            }
            logger.debug("ZIP file " + zipFile + " unziped successed.");
        }
        catch (Throwable ex) {
            logger.error("failed to unzip: ", ex);
        }
        finally {
            if (null != zf) {
                try {
                    zf.close();
                }
                catch (IOException e) {
                    logger.error("Can not close ZipFile: ", e);
                }
            }
        }
        return fileList;
    }

    private static void printUsage() {
        System.out.println("Usage: ");
        System.out.println("\tzip test.zip dir|file,dir|file,...");
        System.out.println("\tunzip test.zip targetDir");
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            ZipFileUtil.printUsage();
            return;
        }
        File zipFile = new File(args[1]);
        if ("zip".equalsIgnoreCase(args[0])) {
            System.out.println("zip file will create at " + zipFile.getAbsolutePath());
            String[] files = args[2].split(",");
            List<String> filePathList = Arrays.asList(files);
            List<File> fileList = Collections.synchronizedList(new LinkedList());
            for (String f : filePathList) {
                fileList.add(new File(f));
            }
            List<String> entryNameList = Collections.synchronizedList(new LinkedList());
            ZipFileUtil.zip(zipFile, entryNameList, fileList, "GBK", "test", (Boolean)false);
            System.out.println("zip file will created.");
        } else if ("unzip".equalsIgnoreCase(args[0])) {
            String targetDir = args[2];
            ZipFileUtil.unzip(args[1], "GBK", targetDir);
        } else {
            ZipFileUtil.printUsage();
            return;
        }
    }
}

