/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.executor.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jiucai.appframework.base.executor.AppExecutorServiceFactory;
import org.jiucai.appframework.common.util.LogUtil;
import org.jiucai.appframework.common.util.Logs;

public class DefaultExecutorService {
    protected static Logs logger = LogUtil.getLog(DefaultExecutorService.class);
    private static String name = "Default";
    private static int maxThreads = 20;
    private static volatile DefaultExecutorService uniqueInstance;
    private static volatile ExecutorService executorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService getExecutorService() {
        if (null != executorService) return executorService;
        Class<DefaultExecutorService> clazz = DefaultExecutorService.class;
        synchronized (DefaultExecutorService.class) {
            if (null != executorService) return executorService;
            logger.info("try to create executorService[name=" + name + "] with " + maxThreads + " threads ...");
            executorService = new ThreadPoolExecutor(maxThreads, maxThreads, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), new ThreadPoolExecutor.CallerRunsPolicy());
            AppExecutorServiceFactory.add(executorService);
            logger.info("executorService[name=" + name + "] with " + maxThreads + " threads created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return executorService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultExecutorService getInstance() {
        if (null != uniqueInstance) return uniqueInstance;
        Class<DefaultExecutorService> clazz = DefaultExecutorService.class;
        synchronized (DefaultExecutorService.class) {
            if (null != uniqueInstance) return uniqueInstance;
            uniqueInstance = new DefaultExecutorService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return uniqueInstance;
        }
    }

    public static DefaultExecutorService setParam(String name, int maxThreads) {
        DefaultExecutorService.name = name;
        DefaultExecutorService.maxThreads = maxThreads;
        return DefaultExecutorService.getInstance();
    }

    private DefaultExecutorService() {
    }

    public String getName() {
        return name;
    }

    public void shutdown() {
        logger.info("try to shutdown executorService: " + name + " ... ");
        if (executorService != null) {
            executorService.shutdownNow();
            logger.info("shutdown executorService: " + name);
        }
    }
}

