/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.helper;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jiucai.appframework.base.helper.SpringHelper;
import org.jiucai.appframework.common.util.LogUtil;
import org.jiucai.appframework.common.util.Logs;

public class AppRequestHelper
extends SpringHelper {
    protected static Logs log = LogUtil.getLog(AppRequestHelper.class);
    protected static final String REQ_PREFIX = "__req_app_";

    public static String getContextBase(HttpServletRequest request) {
        String appBase = "";
        String proxySSl = request.getHeader("SSL");
        String scheme = request.getScheme();
        if (StringUtils.isNotBlank((String)proxySSl)) {
            scheme = "https";
        }
        String appPath = AppRequestHelper.getContextPath(request);
        appBase = 80 != request.getServerPort() ? new StringBuffer(scheme).append("://").append(request.getServerName()).append(":").append(request.getServerPort()).append(appPath).toString() : new StringBuffer(scheme).append("://").append(request.getServerName()).append(appPath).toString();
        return appBase;
    }

    public static String getContextPath(HttpServletRequest request) {
        String appPath = request.getContextPath();
        if (StringUtils.isBlank((String)appPath)) {
            appPath = "";
        }
        return appPath;
    }

    public static void main(String[] args) {
        String val = "https://www.jiucai.org/appframwork/test.htm";
        System.out.println(AppRequestHelper.replaceDomain(val));
    }

    public static synchronized Map<String, Object> parseRequest(HttpServletRequest request) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Object reqAttr = null;
        Enumeration attrs = request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            if (null == attrName || !attrName.startsWith(REQ_PREFIX)) continue;
            String paraName = attrName.substring(attrName.indexOf(REQ_PREFIX) + REQ_PREFIX.length(), attrName.length());
            reqAttr = request.getAttribute(attrName);
            param.put(paraName, reqAttr);
        }
        return param;
    }

    public static Map<String, String> parseRequest(HttpServletRequest request, String reqPrefix) {
        HashMap<String, String> param = new HashMap<String, String>();
        Object reqAttr = null;
        Enumeration attrs = request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            if (null == attrName || !attrName.startsWith(reqPrefix)) continue;
            String paraName = attrName.substring(attrName.indexOf(reqPrefix) + reqPrefix.length(), attrName.length());
            reqAttr = request.getAttribute(attrName);
            String attrVal = "";
            if (null != reqAttr) {
                attrVal = reqAttr.toString();
            }
            param.put(paraName, attrVal);
        }
        return param;
    }

    public static String replaceDomain(String val) {
        String result = val;
        if (StringUtils.isBlank((String)result)) {
            return "";
        }
        int pos = -1;
        if (((result = result.toLowerCase()).startsWith("http://") || result.startsWith("https://")) && (pos = result.indexOf("/", 8)) > -1) {
            result = result.substring(pos);
        }
        return result;
    }
}

