/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.listener;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServletRequest;
import org.jiucai.appframework.base.listener.AbstractBaseListener;
import org.jiucai.appframework.base.util.IpUtil;
import org.slf4j.impl.Log4jMDCAdapter;
import org.slf4j.spi.MDCAdapter;

@WebListener(value="a listener to save user ip to log4j ")
public class AppLogListener
extends AbstractBaseListener
implements ServletRequestListener {
    protected MDCAdapter adapter;

    public AppLogListener() {
        this.log.info("AppLogListener inited.");
        this.adapter = new Log4jMDCAdapter();
    }

    public void requestInitialized(ServletRequestEvent event) {
        HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
        String ip = IpUtil.getIp(request);
        this.adapter.put("ip", ip);
    }

    public void requestDestroyed(ServletRequestEvent event) {
        this.adapter.remove("ip");
    }
}

