/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jiucai.appframework.base.domain.KeyValuePair;
import org.jiucai.appframework.common.csv.CsvWriter;
import org.jiucai.appframework.common.util.BaseUtil;

public class CsvDownloadUtil
extends BaseUtil {
    protected static String fileCharset = "GBK";
    protected static String cellPrefix = "";
    protected static String cellSuffix = "";
    protected static Boolean preserveSpaces = true;

    public static String getFileName(String displayName) {
        String displayFileName = displayName;
        SimpleDateFormat df = new SimpleDateFormat("MMddHHmmss");
        String dateStr = df.format(new Date());
        if (!(displayFileName = displayFileName + "_" + dateStr).endsWith(".csv")) {
            displayFileName = displayFileName + ".csv";
        }
        return displayFileName;
    }

    public static final String saveFile(String filePath, String fileName, List<KeyValuePair> headList, List<Map<String, Object>> dataList, List<Map<String, Object>> sumList, Boolean isAppend) {
        String basePath = filePath;
        StringBuffer fileSavedName = new StringBuffer();
        if (StringUtils.isEmpty((String)filePath)) {
            basePath = "/tmp/report";
            log.debug("use default file path:  " + basePath);
        } else {
            log.debug("use user set file path:  " + filePath);
        }
        fileSavedName.append(basePath);
        if (!filePath.endsWith("/")) {
            fileSavedName.append("/");
        }
        if (!fileName.endsWith(".csv")) {
            fileName = fileName + ".csv";
        }
        String createFilePath = fileSavedName.toString();
        log.info("FilePath: " + createFilePath);
        fileSavedName.append(fileName);
        try {
            String[] rowData;
            List[] data;
            List<List<String>> datas;
            File file = new File(createFilePath);
            if (!file.isDirectory()) {
                file.mkdirs();
            }
            FileOutputStream out = new FileOutputStream(fileSavedName.toString(), (boolean)isAppend);
            CsvWriter wr = new CsvWriter(out, ',', Charset.forName(fileCharset));
            wr.setForceQualifier(true);
            if (CollectionUtils.isNotEmpty(headList) && !isAppend.booleanValue()) {
                ArrayList<String> headNamesList = new ArrayList<String>();
                for (KeyValuePair kvp : headList) {
                    headNamesList.add(CsvDownloadUtil.getConvertedMapValue(kvp.getText()));
                }
                for (int i = 0; i < headNamesList.size(); ++i) {
                    headNamesList.set(i, (String)headNamesList.get(i));
                }
                String[] rowData2 = headNamesList.toArray(new String[headNamesList.size()]);
                wr.writeRecord(rowData2, preserveSpaces);
            }
            if (CollectionUtils.isNotEmpty(sumList) && !isAppend.booleanValue()) {
                datas = CsvDownloadUtil.getCsvHeadList(headList, sumList);
                for (List da : data = (List[])datas.toArray(new ArrayList[datas.size()])) {
                    for (int i = 0; i < da.size(); ++i) {
                        da.set(i, da.get(i));
                    }
                    rowData = da.toArray(new String[da.size()]);
                    wr.writeRecord(rowData, preserveSpaces);
                }
            }
            if (CollectionUtils.isNotEmpty(dataList)) {
                datas = CsvDownloadUtil.getCsvHeadList(headList, dataList);
                for (List da : data = (List[])datas.toArray(new ArrayList[datas.size()])) {
                    for (int i = 0; i < da.size(); ++i) {
                        da.set(i, da.get(i));
                    }
                    rowData = da.toArray(new String[da.size()]);
                    wr.writeRecord(rowData, preserveSpaces);
                }
            }
            wr.close();
            ((OutputStream)out).close();
            wr = null;
            out = null;
        }
        catch (FileNotFoundException e) {
            log.error("\u6587\u4ef6 " + fileSavedName.toString() + " \u4e0d\u5b58\u5728: " + e);
        }
        catch (IOException e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38: " + e);
        }
        return fileSavedName.toString();
    }

    public static void setCellPrefix(String prefix) {
        cellPrefix = prefix;
    }

    public static void setCellSuffix(String suffix) {
        cellSuffix = suffix;
    }

    public static void setCharset(String charset) {
        fileCharset = charset;
    }

    public static void setPreserveSpaces(Boolean allowSpaces) {
        preserveSpaces = allowSpaces;
    }

    private static List<List<String>> getCsvHeadList(List<KeyValuePair> headList, List<Map<String, Object>> dataList) {
        ArrayList<List<String>> dataBody = new ArrayList<List<String>>();
        ArrayList<String> data = null;
        ArrayList<String> headCode = new ArrayList<String>();
        if (null != headList) {
            for (KeyValuePair keyValuePair : headList) {
                headCode.add(keyValuePair.getCode().toLowerCase());
            }
        }
        for (Map map : dataList) {
            data = new ArrayList<String>();
            for (String code : headCode) {
                data.add(CsvDownloadUtil.getConvertedMapValue(map.get(code)));
            }
            dataBody.add(data);
        }
        return dataBody;
    }

    protected static String getConvertedMapValue(Object val) {
        return new StringBuffer(cellPrefix).append(CsvDownloadUtil.convertMapValue(val)).append(cellSuffix).toString();
    }
}

