/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.util;

import java.net.URL;
import org.jiucai.appframework.common.util.BaseUtil;

public class DomainUtil
extends BaseUtil {
    protected static String[] rootDomains = new String[]{".com.cn", ".net.cn", ".org.cn", ".gov.cn", ".edu.cn", ".com.hk", ".net.hk", ".org.hk", ".gov.hk", ".edu.hk", ".com.tw", ".net.tw", ".org.tw", ".gov.tw", ".edu.tw", ".com", ".net", ".org", ".edu", ".cn", ".hk", ".tw", ".biz", ".info", ".mobi", ".name", ".sh", ".ac", ".travel", ".tm", ".us", ".cc", ".mn", ".asia", ".ws", ".tel", ".cm"};
    protected static String[] protocols = new String[]{"http", "https", "ftp", "svn", "udp", "thunder", "flashget", "ed2k", "ssh"};

    public static synchronized String getDomain(String url) {
        String domain;
        block8: {
            domain = url;
            String tmpDomain = "";
            try {
                if (null != domain) {
                    domain = domain.trim().toLowerCase();
                    tmpDomain = domain = domain.replace(" ", "");
                    URL a = new URL(domain);
                    if (null == (domain = a.getHost()) || "".equals(domain)) {
                        domain = tmpDomain;
                        throw new Exception("Bad value from URL.getHost(), use paramter: " + url);
                    }
                    break block8;
                }
                return domain;
            }
            catch (Exception e) {
                domain = DomainUtil.replaceProtocol(domain);
                int endPos = domain.indexOf("/");
                if (endPos > -1) {
                    domain = domain.substring(0, endPos);
                }
                if (!DomainUtil.isIp(domain).booleanValue() || (endPos = (domain = DomainUtil.replaceIpV6(domain)).lastIndexOf(":")) <= -1) break block8;
                String portStr = domain.substring(endPos + 1, domain.length());
                try {
                    int port;
                    if (portStr.length() > 0 && portStr.length() <= 5 && (port = Integer.valueOf(portStr).intValue()) > 0 && port < 65535) {
                        domain = domain.substring(0, endPos);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return domain;
    }

    public static synchronized String getSubDomain(String url, int level) {
        String domain = url;
        domain = DomainUtil.getDomain(url);
        if (null == domain) {
            return domain;
        }
        if (DomainUtil.isIp(domain).booleanValue()) {
            return DomainUtil.replaceIpV6(domain);
        }
        int endPos = domain.lastIndexOf(":");
        if (endPos > -1) {
            domain = domain.substring(0, endPos);
        }
        String rootDomain = "";
        for (int i = 0; i < rootDomains.length; ++i) {
            if (!domain.endsWith(rootDomains[i])) continue;
            domain = domain.replace(rootDomains[i], "");
            rootDomain = rootDomains[i];
            break;
        }
        if (level <= 1) {
            int endPos2 = domain.lastIndexOf(".");
            if (endPos2 > -1) {
                domain = domain.substring(endPos2 + 1, domain.length());
            }
            domain = "." + domain + rootDomain;
        } else {
            String[] subParts = domain.split("[.]");
            if (subParts.length > 0 && subParts.length >= level) {
                int stopPos = 0;
                for (int i = 0; i < subParts.length; ++i) {
                    if (i != subParts.length - level) continue;
                    stopPos = i;
                    break;
                }
                StringBuffer tempDomain = new StringBuffer();
                for (int i = 0; i < subParts.length; ++i) {
                    if (i < stopPos) continue;
                    tempDomain.append(".").append(subParts[i]);
                }
                domain = tempDomain + rootDomain;
            } else {
                int endPos3 = domain.lastIndexOf(".");
                if (endPos3 > -1) {
                    domain = domain.substring(endPos3 + 1, domain.length());
                }
                domain = "." + domain + rootDomain;
            }
        }
        return domain;
    }

    public static synchronized String getTopDomain(String url) {
        return DomainUtil.getSubDomain(url, 1);
    }

    public static synchronized Boolean isIp(String domain) {
        String result = DomainUtil.replaceIpV6(domain);
        if (null != result) {
            try {
                result = result.replace(".", "");
                result = result.replace(":", "");
                DomainUtil.hex2Byte(result);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        long start = System.nanoTime();
        long start2 = System.currentTimeMillis();
        DomainUtil.test();
        System.out.println("--------------------------------");
        System.out.println("nanoTime: " + (System.nanoTime() - start) / 100000L + " ms");
        System.out.println("currentTimeMillis: " + (System.currentTimeMillis() - start2) / 100000L + " ms");
    }

    private static synchronized byte[] hex2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    private static synchronized String replaceIpV6(String domain) {
        if (domain.indexOf("[") > -1 && domain.lastIndexOf("]") > -1) {
            domain = domain.replace("[", "");
            domain = domain.replace("]", "");
        }
        return domain;
    }

    private static synchronized String replaceProtocol(String domain) {
        if (null == domain) {
            return domain;
        }
        for (int i = 0; i < protocols.length; ++i) {
            domain = domain.replaceAll("^" + protocols[i] + ":[/]*", "");
        }
        domain = domain.replaceAll("^\\w+:\\w*@", "");
        return domain;
    }

    private static synchronized void test() {
        System.out.println("--------- DomainUtil testcase by zhaidw: ---------");
        String[] urls = new String[]{"http://www.emar.com.cn", "http:www.jiucai.org", "adwiser.emarbox.com", "https://www.emar.com.hk/test/test.htm", "thunder:a5.a4.a3.a2.emar.com.cn/index.jsp", "ftp://upload.test-test.org", "ftp://username:password@f.jiucai.org:21/upload", "ftp://username@upload.jiucai.org/upload", "0:0:0:FFFF:129.144.52.38/index.jsp", "http://1080::8:800::::", "https://[2001:db8:85a3:8d3:1319:8a2e:370:7348]:443/", "[2001:db8:85a3:8d3:1319:::]:443", "ftp://username:password@[2001:db8:85a3:8d3:1319:8a2e:370:7348]:21/upload"};
        for (int i = 0; i < urls.length; ++i) {
            System.out.println("url[" + (i + 1) + "]: " + urls[i]);
            System.out.println("TopDomain: " + DomainUtil.getTopDomain(urls[i]));
            System.out.println("Level 2 SubDomain: " + DomainUtil.getSubDomain(urls[i], 2));
        }
    }
}

