/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.jiucai.appframework.common.util.LogUtil;
import org.jiucai.appframework.common.util.Logs;

public class ExcelUtil {
    protected static Logs log = LogUtil.getLog(ExcelUtil.class);

    public static void createExcel(String sheetName, List<Map<String, Object>> list, String[] titles, String[] fieldNames, OutputStream output) {
        HSSFWorkbook wb = null;
        try {
            HSSFSheet sheet = null;
            int k = 0;
            if (sheetName == null) {
                sheetName = "sheet1";
            }
            wb = new HSSFWorkbook();
            sheet = wb.createSheet(sheetName);
            HSSFRow topRow = sheet.createRow(0);
            for (int i = 0; i < titles.length; ++i) {
                ExcelUtil.setCellValue(topRow.createCell(i), titles[i]);
            }
            k = 1;
            for (Map<String, Object> map : list) {
                HSSFRow row = sheet.createRow(k);
                for (int i = 0; i < fieldNames.length; ++i) {
                    ExcelUtil.setCellValue(row.createCell(i), map.get(fieldNames[i]) == null ? "" : map.get(fieldNames[i]));
                }
                ++k;
            }
            if (null != wb && null != output) {
                wb.write(output);
            }
        }
        catch (Exception e) {
            log.error("create excel failed: ", e);
        }
    }

    public static String[][] readExcel(File file, int ignoreRows) throws FileNotFoundException, IOException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        int rowSize = 0;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)in);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFCell cell = null;
        for (int sheetIndex = 0; sheetIndex < wb.getNumberOfSheets(); ++sheetIndex) {
            HSSFSheet st = wb.getSheetAt(sheetIndex);
            for (int rowIndex = ignoreRows; rowIndex <= st.getLastRowNum(); ++rowIndex) {
                HSSFRow row = st.getRow(rowIndex);
                if (row == null) continue;
                int tempRowSize = row.getLastCellNum() + 1;
                if (tempRowSize > rowSize) {
                    rowSize = tempRowSize;
                }
                Object[] values = new String[rowSize];
                Arrays.fill(values, "");
                boolean hasValue = false;
                for (int columnIndex = 0; columnIndex <= row.getLastCellNum(); ++columnIndex) {
                    String value = "";
                    cell = row.getCell(columnIndex);
                    if (cell != null) {
                        switch (cell.getCellType()) {
                            case 1: {
                                value = cell.getRichStringCellValue().getString();
                                break;
                            }
                            case 0: {
                                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                    Date date = cell.getDateCellValue();
                                    if (date != null) {
                                        value = new SimpleDateFormat("yyyy-MM-dd").format(date);
                                        break;
                                    }
                                    value = "";
                                    break;
                                }
                                value = new DecimalFormat("0").format(cell.getNumericCellValue());
                                break;
                            }
                            case 2: {
                                if (!cell.getStringCellValue().equals("")) {
                                    value = cell.getStringCellValue();
                                    break;
                                }
                                value = cell.getNumericCellValue() + "";
                                break;
                            }
                            case 3: {
                                break;
                            }
                            case 5: {
                                value = "";
                                break;
                            }
                            case 4: {
                                value = cell.getBooleanCellValue() ? "Y" : "N";
                                break;
                            }
                            default: {
                                value = "";
                            }
                        }
                    }
                    if (columnIndex == 0 && value.trim().equals("")) break;
                    values[columnIndex] = ExcelUtil.rightTrim(value);
                    values[columnIndex] = value.trim();
                    hasValue = true;
                }
                if (!hasValue) continue;
                result.add(values);
            }
        }
        in.close();
        String[][] returnArray = new String[result.size()][rowSize];
        for (int i = 0; i < returnArray.length; ++i) {
            returnArray[i] = (String[])result.get(i);
        }
        return returnArray;
    }

    protected static String rightTrim(String str) {
        if (str == null) {
            return "";
        }
        int length = str.length();
        for (int i = length - 1; i >= 0 && str.charAt(i) == ' '; --i) {
            --length;
        }
        return str.substring(0, length);
    }

    protected static void setCellValue(HSSFCell cell, Object value) {
        cell.setCellType(0);
        if (null == value) {
            cell.setCellType(3);
            cell.setCellValue("");
        } else if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Long) {
            cell.setCellValue((double)((Long)value).longValue());
        } else if (value instanceof Float) {
            cell.setCellValue((double)((Float)value).floatValue());
        } else if (value instanceof Float) {
            cell.setCellValue((double)((Float)value).floatValue());
        } else if (value instanceof BigInteger) {
            cell.setCellValue((double)((BigInteger)value).longValue());
        } else if (value instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)value).doubleValue());
        } else {
            HSSFRichTextString str = new HSSFRichTextString(String.valueOf(value));
            cell.setCellType(1);
            cell.setCellValue((RichTextString)str);
        }
    }
}

