/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.util;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.jiucai.appframework.base.helper.AppRequestHolder;

public class CookieUtil {
    public static int defaultCookieLife = 604800;

    public static void addCookie(HttpServletResponse response, String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(defaultCookieLife);
        response.addCookie(cookie);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(maxAge);
        response.addCookie(cookie);
    }

    public static Cookie getCookieByName(String name) {
        Map<String, Cookie> cookieMap = CookieUtil.readCookieMap();
        if (cookieMap.containsKey(name)) {
            Cookie cookie = cookieMap.get(name);
            return cookie;
        }
        return null;
    }

    public static String getCookieValue(String name) {
        String cookieValue = "";
        Cookie c = CookieUtil.getCookieByName(name);
        if (null != c) {
            cookieValue = c.getValue();
        }
        return cookieValue;
    }

    public static Map<String, Cookie> readCookieMap() {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = AppRequestHolder.getRequest().getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return cookieMap;
    }
}

