/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    public static final String CHARSET_UTF8 = "UTF-8";
    protected static Log logger = LogFactory.getLog(HttpClientUtil.class);
    private static ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

        public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            int code = response.getStatusLine().getStatusCode();
            if (200 != code) {
                return String.valueOf(code);
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                Charset charset = ContentType.getOrDefault((HttpEntity)entity).getCharset();
                if (null != charset) {
                    return new String(EntityUtils.toByteArray((HttpEntity)entity), charset);
                }
                return new String(EntityUtils.toByteArray((HttpEntity)entity));
            }
            return null;
        }
    };

    public static void abortConnection(HttpUriRequest hrb, CloseableHttpClient httpclient) {
        if (hrb != null) {
            hrb.abort();
        }
        if (httpclient != null) {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                logger.error((Object)"failed to close httpclient", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore createKeyStore(URL url, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("Keystore url may not be null");
        }
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream is = null;
        try {
            is = url.openStream();
            keystore.load(is, password != null ? password.toCharArray() : null);
        }
        finally {
            if (is != null) {
                is.close();
                is = null;
            }
        }
        return keystore;
    }

    public static String get(String url) {
        return HttpClientUtil.get(url, null, null);
    }

    public static String get(String url, Map<String, String> params) {
        return HttpClientUtil.get(url, params, null);
    }

    public static String get(String url, Map<String, String> params, String charset) {
        if (url == null || StringUtils.isEmpty((String)url)) {
            return null;
        }
        List<NameValuePair> qparams = HttpClientUtil.getParamsList(params);
        if (qparams != null && qparams.size() > 0) {
            charset = charset == null ? CHARSET_UTF8 : charset;
            String formatParams = URLEncodedUtils.format(qparams, (String)charset);
            url = url.indexOf("?") < 0 ? url + "?" + formatParams : url.substring(0, url.indexOf("?") + 1) + formatParams;
        }
        CloseableHttpClient httpclient = HttpClientUtil.getHttpClient(charset);
        HttpGet hg = new HttpGet(url);
        String responseStr = null;
        try {
            responseStr = (String)httpclient.execute((HttpUriRequest)hg, responseHandler);
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException("\u5ba2\u6237\u7aef\u8fde\u63a5\u534f\u8bae\u9519\u8bef", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO\u64cd\u4f5c\u5f02\u5e38", e);
        }
        finally {
            HttpClientUtil.abortConnection((HttpUriRequest)hg, httpclient);
        }
        return responseStr;
    }

    public static HttpClientConnectionManager getConnectionManager() {
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setMaxTotal(100);
        connManager.setDefaultMaxPerRoute(100);
        return connManager;
    }

    public static CloseableHttpClient getHttpClient(String charset) {
        HttpClientBuilder builder = HttpClientUtil.getHttpClientBuilder(charset);
        CloseableHttpClient httpclient = builder.build();
        return httpclient;
    }

    public static HttpClientBuilder getHttpClientBuilder(String charset) {
        HttpClientBuilder builder = HttpClients.custom();
        Charset chartset = charset == null ? Charset.forName(CHARSET_UTF8) : Charset.forName(charset);
        ConnectionConfig.Builder connBuilder = ConnectionConfig.custom().setCharset(chartset);
        RequestConfig.Builder reqBuilder = RequestConfig.custom();
        reqBuilder.setExpectContinueEnabled(false);
        reqBuilder.setSocketTimeout(600000);
        reqBuilder.setConnectTimeout(600000);
        DefaultServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy = new DefaultServiceUnavailableRetryStrategy(3, 3000);
        builder.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)serviceUnavailableRetryStrategy);
        builder.setUserAgent("Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/43.0.2357.124 Safari/537.36");
        builder.setDefaultRequestConfig(reqBuilder.build());
        builder.setDefaultConnectionConfig(connBuilder.build());
        builder.setConnectionManager(HttpClientUtil.getConnectionManager());
        return builder;
    }

    public static List<NameValuePair> getParamsList(Map<String, String> paramsMap) {
        if (paramsMap == null || paramsMap.size() == 0) {
            return null;
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> map : paramsMap.entrySet()) {
            params.add((NameValuePair)new BasicNameValuePair(map.getKey(), map.getValue()));
        }
        return params;
    }

    public static String post(String url, Map<String, String> params) {
        return HttpClientUtil.post(url, params, CHARSET_UTF8);
    }

    public static String post(String url, Map<String, String> params, String charset) {
        if (url == null || StringUtils.isEmpty((String)url)) {
            return null;
        }
        CloseableHttpClient httpclient = HttpClientUtil.getHttpClient(charset);
        UrlEncodedFormEntity formEntity = null;
        try {
            if (charset == null || StringUtils.isEmpty((String)charset)) {
                if (null != params && params.size() > 0) {
                    formEntity = new UrlEncodedFormEntity(HttpClientUtil.getParamsList(params));
                }
            } else if (null != params && params.size() > 0) {
                formEntity = new UrlEncodedFormEntity(HttpClientUtil.getParamsList(params), charset);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7f16\u7801\u96c6", e);
        }
        HttpPost hp = new HttpPost(url);
        if (null != formEntity) {
            hp.setEntity((HttpEntity)formEntity);
        }
        String responseStr = null;
        try {
            responseStr = (String)httpclient.execute((HttpUriRequest)hp, responseHandler);
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException("\u5ba2\u6237\u7aef\u8fde\u63a5\u534f\u8bae\u9519\u8bef", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO\u64cd\u4f5c\u5f02\u5e38", e);
        }
        finally {
            HttpClientUtil.abortConnection((HttpUriRequest)hp, httpclient);
        }
        return responseStr;
    }

    public static String post(String url, Map<String, String> params, String charset, boolean isSecure) {
        String result = null;
        result = isSecure ? HttpClientUtil.post(url, params, charset, null, "") : HttpClientUtil.post(url, params, charset);
        return result;
    }

    @Deprecated
    public static String post(String url, Map<String, String> params, String charset, URL keystoreUrl, String keystorePassword) {
        if (url == null || StringUtils.isEmpty((String)url)) {
            return null;
        }
        UrlEncodedFormEntity formEntity = null;
        try {
            if (charset == null || StringUtils.isEmpty((String)charset)) {
                if (null != params && params.size() > 0) {
                    formEntity = new UrlEncodedFormEntity(HttpClientUtil.getParamsList(params));
                }
            } else if (null != params && params.size() > 0) {
                formEntity = new UrlEncodedFormEntity(HttpClientUtil.getParamsList(params), charset);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7f16\u7801\u96c6", e);
        }
        CloseableHttpClient httpclient = null;
        HttpPost hp = null;
        String responseStr = null;
        try {
            HttpClientBuilder builder = HttpClientUtil.getHttpClientBuilder(charset);
            SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
            httpclient = builder.build();
            hp = new HttpPost(url);
            if (null != formEntity) {
                hp.setEntity((HttpEntity)formEntity);
            }
            responseStr = (String)httpclient.execute((HttpUriRequest)hp, responseHandler);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("I/O\u64cd\u4f5c\u5931\u8d25\u6216\u4e2d\u65ad ", e);
            }
            catch (Throwable throwable) {
                HttpClientUtil.abortConnection(hp, httpclient);
                throw throwable;
            }
        }
        HttpClientUtil.abortConnection((HttpUriRequest)hp, httpclient);
        return responseStr;
    }
}

