/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.web.render;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.jiucai.appframework.base.web.render.BaseRender;
import org.springframework.stereotype.Service;

@Service(value="jsonRender")
public class JsonRender
extends BaseRender {
    private String encoding;
    private static ObjectMapper mapper = new ObjectMapper();

    public JsonRender() {
    }

    public JsonRender(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public ObjectMapper getObjectMapper() {
        return mapper;
    }

    @Override
    public String getContentType() {
        return "application/json; charset=" + this.encoding;
    }

    @Override
    public String getString(Object data) {
        String result = null;
        try {
            result = mapper.writeValueAsString(data);
        }
        catch (Throwable e) {
            this.log.error("output failed:", e);
            throw new RuntimeException(e);
        }
        return result;
    }

    static {
        mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
    }
}

