/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jiucai.appframework.common.util.BaseUtil;
import org.jiucai.appframework.common.util.SwfInfo;

public class SwfUtil
extends BaseUtil {
    public static SwfInfo getInfo(File file) throws FileNotFoundException {
        SwfInfo info = null;
        try {
            info = SwfUtil.getInfo(new FileInputStream(file));
        }
        catch (IOException e) {
            log.error("IOException: " + ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        return info;
    }

    public static SwfInfo getInfo(InputStream fis) throws IOException {
        SwfInfo info = null;
        byte[] hdr = SwfUtil.getByteInternal(fis);
        info = SwfUtil.getSwfUtilInternal(hdr);
        return info;
    }

    public static SwfInfo getInfo(String path) throws FileNotFoundException {
        return SwfUtil.getInfo(new File(path));
    }

    private static int[] decodeRect(BitReader rdr) {
        int[] dims = new int[4];
        int nBits = rdr.uBits(5);
        dims[0] = rdr.sBits(nBits);
        dims[1] = rdr.sBits(nBits);
        dims[2] = rdr.sBits(nBits);
        dims[3] = rdr.sBits(nBits);
        return dims;
    }

    private static byte[] expand(byte[] bytes, int skip) {
        byte[] newBytes = new byte[bytes.length - skip];
        Inflater inflater = new Inflater();
        inflater.setInput(bytes, skip, newBytes.length);
        try {
            int outCount = inflater.inflate(newBytes);
            System.arraycopy(newBytes, 0, bytes, skip, outCount);
            Arrays.fill(bytes, skip + outCount, bytes.length, (byte)0);
            return bytes;
        }
        catch (DataFormatException e) {
            return null;
        }
    }

    private static byte[] getByteInternal(InputStream fis) throws IOException {
        byte[] bytes = new byte[128];
        if (fis.read(bytes) < bytes.length) {
            bytes = null;
        } else if (bytes[0] == 67 && bytes[1] == 87 && bytes[2] == 83) {
            bytes = SwfUtil.expand(bytes, 8);
        } else if (bytes[0] != 70 || bytes[1] != 87 || bytes[2] != 83) {
            bytes = null;
        }
        return bytes;
    }

    private static SwfInfo getSwfUtilInternal(byte[] hdr) {
        if (hdr == null) {
            return null;
        }
        SwfInfo info = new SwfInfo();
        if (67 == hdr[0]) {
            info.setCompressed(true);
        } else {
            info.setCompressed(false);
        }
        info.setVersion(hdr[3]);
        info.setSize(hdr[4] & 0xFF | (hdr[5] & 0xFF) << 8 | (hdr[6] & 0xFF) << 16 | hdr[7] << 24);
        BitReader rdr = new BitReader(hdr, 8);
        int[] dims = SwfUtil.decodeRect(rdr);
        info.setWidth((dims[1] - dims[0]) / 20);
        info.setHeight((dims[3] - dims[2]) / 20);
        info.setFps((float)rdr.uI16() / 256.0f);
        info.setFrameCount(rdr.uI16());
        return info;
    }

    private SwfUtil() {
    }

    static class BitReader {
        private byte[] bytes;
        private int byteIdx;
        private int bitIdx = 0;

        public BitReader(byte[] bytes) {
            this(bytes, 0);
        }

        public BitReader(byte[] bytes, int startIndex) {
            this.bytes = bytes;
            this.byteIdx = startIndex;
        }

        public int sBits(int bitCount) {
            int value = this.getBit() == 0 ? 0 : -1;
            --bitCount;
            while (--bitCount >= 0) {
                value = value << 1 | this.getBit();
            }
            return value;
        }

        public void sync() {
            if (this.bitIdx > 0) {
                ++this.byteIdx;
                this.bitIdx = 0;
            }
        }

        public int uBits(int bitCount) {
            int value = 0;
            while (--bitCount >= 0) {
                value = value << 1 | this.getBit();
            }
            return value;
        }

        public int uI16() {
            this.sync();
            return this.bytes[this.byteIdx++] & 0xFF | (this.bytes[this.byteIdx++] & 0xFF) << 8;
        }

        private int getBit() {
            int value = this.bytes[this.byteIdx] >> 7 - this.bitIdx & 1;
            if (++this.bitIdx == 8) {
                this.bitIdx = 0;
                ++this.byteIdx;
            }
            return value;
        }
    }
}

