/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeSpeedLimitUtil {
    protected static Logger log = LoggerFactory.getLogger(InvokeSpeedLimitUtil.class);
    protected static int speedLimitCount = 0;
    protected static long speedLimitInterval = 0L;
    protected static int sleepTimeInSeconds = 10;
    private static int executedCount = 0;
    private static long lastRunTime = 0L;

    public static synchronized void limitSpeed(int updateCount) {
        if (speedLimitCount <= 0 || speedLimitInterval <= 0L) {
            return;
        }
        executedCount += updateCount;
        long nowTime = System.currentTimeMillis();
        if (lastRunTime == 0L) {
            lastRunTime = nowTime;
        }
        while (InvokeSpeedLimitUtil.checkOverLimit(nowTime)) {
            try {
                log.info("\u8c03\u7528\u901f\u5ea6\u5df2\u8fbe\u5230 " + speedLimitCount + " \u6b21/" + speedLimitInterval / 1000L + " \u79d2\u7684\u9650\u5236,\u5728 " + (nowTime - lastRunTime) / 1000L + " \u79d2\u5185\u5df2\u8c03\u7528 " + executedCount + " \u6b21,\u6682\u505c" + sleepTimeInSeconds + "\u79d2 ...");
                Thread.sleep(sleepTimeInSeconds * 1000);
            }
            catch (InterruptedException e) {
                log.warn("\u63a5\u53d7\u5230\u7ebf\u7a0b\u9000\u51fa\u4fe1\u53f7,\u9000\u51fa");
                return;
            }
            nowTime = System.currentTimeMillis();
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < 100; ++i) {
            System.out.println("\u7b2c " + i + " \u6b21\u8c03\u7528\u5f00\u59cb");
            InvokeSpeedLimitUtil.limitSpeed(50);
            System.out.println("\u7b2c " + i + " \u6b21\u8c03\u7528\u7ed3\u675f");
        }
    }

    public static void setLimit(int limitCount, int limitInterval, int waitTimeInSeconds) {
        if (limitCount < 0 || limitInterval < 0) {
            throw new RuntimeException("param can not be null.");
        }
        speedLimitCount = limitCount;
        speedLimitInterval = limitInterval * 1000;
        sleepTimeInSeconds = waitTimeInSeconds;
    }

    private static boolean checkOverLimit(long nowTime) {
        long timedurion = nowTime - lastRunTime;
        if (timedurion < speedLimitInterval) {
            if (executedCount > speedLimitCount) {
                return true;
            }
        } else {
            lastRunTime = nowTime;
            executedCount = 0;
        }
        return false;
    }

    static {
        speedLimitCount = 22;
        speedLimitInterval = 60000L;
    }
}

