/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.util;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xxtea.XXTEA;

public final class WebSafeXxtea {
    private static Logger logger = LoggerFactory.getLogger(WebSafeXxtea.class);

    public static String decrypt(String encodeData, String encKey) {
        String data = "";
        if (StringUtils.isBlank((String)encodeData)) {
            return data;
        }
        try {
            data = encodeData.replace("-", "+").replace("_", "/").replace("*", "=");
            data = XXTEA.decryptBase64StringToString((String)data, (String)encKey);
        }
        catch (Throwable e) {
            logger.error("xxtea decrypt failed, {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return data;
    }

    public static String encrypt(String plainData, String encKey) {
        String encodeData = "";
        if (StringUtils.isBlank((String)plainData)) {
            return encodeData;
        }
        try {
            encodeData = XXTEA.encryptToBase64String((String)plainData, (String)encKey);
            encodeData = encodeData.replace("+", "-").replace("/", "_").replace("=", "*");
        }
        catch (Throwable e) {
            logger.error("xxtea encrypt failed, {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return encodeData;
    }
}

