/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.web.render;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jiucai.appframework.base.util.JsonUtil;
import org.jiucai.appframework.base.web.render.BaseRender;
import org.springframework.stereotype.Service;

@Service(value="jsonRender")
public class JsonRender
extends BaseRender {
    private String encoding;
    private static ObjectMapper mapper = JsonUtil.getObjectMapper();

    public JsonRender() {
    }

    public JsonRender(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public ObjectMapper getObjectMapper() {
        return mapper;
    }

    @Override
    public String getContentType() {
        return "application/json; charset=" + this.encoding;
    }

    @Override
    public String getString(Object data) {
        String result = null;
        try {
            result = mapper.writeValueAsString(data);
        }
        catch (Throwable e) {
            this.log.error("output failed:", e);
            throw new RuntimeException(e);
        }
        return result;
    }
}

