/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.encrypt;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.jiucai.appframework.common.encrypt.AbstractPGPEncryptor;

public class PGPEncryptor
extends AbstractPGPEncryptor {
    public static String encrypt(String strToEncrtpt, String pulicKeyFilePath) throws Exception {
        byte[] encrypted = PGPEncryptor.encryptByte(strToEncrtpt, pulicKeyFilePath);
        return new String(encrypted);
    }

    public static String encrypt(String strToEncrtpt, String pulicKeyFilePath, String outFile) throws Exception {
        byte[] encrypted = PGPEncryptor.encryptByte(strToEncrtpt, pulicKeyFilePath);
        PGPEncryptor.writeToFile(encrypted, outFile);
        return new String(encrypted);
    }

    public static byte[] encryptByte(String strToEncrtpt, String pulicKeyFilePath) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] original = strToEncrtpt.getBytes();
        byte[] encrypted = PGPEncryptor.encrypt(original, PGPEncryptor.readPublicKey(pulicKeyFilePath), null, true, true);
        return encrypted;
    }

    private static byte[] encrypt(byte[] clearData, PGPPublicKey encKey, String fileName, boolean withIntegrityCheck, boolean armor) throws IOException, PGPException, NoSuchProviderException {
        ByteArrayOutputStream encOut;
        if (fileName == null) {
            fileName = "_CONSOLE";
        }
        ByteArrayOutputStream out = encOut = new ByteArrayOutputStream();
        if (armor) {
            out = new ArmoredOutputStream((OutputStream)out);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PGPCompressedDataGenerator comData = new PGPCompressedDataGenerator(1);
        OutputStream cos = comData.open((OutputStream)bOut);
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        OutputStream pOut = lData.open(cos, 'b', fileName, (long)clearData.length, new Date());
        pOut.write(clearData);
        pOut.flush();
        pOut.close();
        cos.close();
        lData.close();
        comData.close();
        BcPGPDataEncryptorBuilder encryptorBuilder = new BcPGPDataEncryptorBuilder(3);
        PGPEncryptedDataGenerator cPk = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)encryptorBuilder);
        BcPublicKeyKeyEncryptionMethodGenerator methodGenerator = new BcPublicKeyKeyEncryptionMethodGenerator(encKey);
        methodGenerator.setSecureRandom(new SecureRandom());
        cPk.addMethod((PGPKeyEncryptionMethodGenerator)methodGenerator);
        byte[] bytes = bOut.toByteArray();
        OutputStream cOut = cPk.open((OutputStream)out, (long)bytes.length);
        cOut.write(bytes);
        cOut.flush();
        cOut.close();
        ((OutputStream)out).close();
        return encOut.toByteArray();
    }

    protected static void writeToFile(byte[] byteData, String fileName) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileName);
        fos.write(byteData);
        fos.flush();
        fos.close();
    }
}

