/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.security;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.jiucai.appframework.common.encode.Base64;
import org.jiucai.appframework.common.security.AsymmetricEncryptor;
import org.jiucai.appframework.common.security.DSA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSA
extends AsymmetricEncryptor {
    private static final String algorithmKey = "RSA";
    private static final String algorithmSignatureKey = "MD5withRSA";
    protected static Logger log = LoggerFactory.getLogger(RSA.class);

    public static Map<String, Object> initKey(String seed) {
        KeyPairGenerator keygen = null;
        try {
            keygen = KeyPairGenerator.getInstance(algorithmKey);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("invalid algorithmKeyRSA", (Throwable)e);
            return null;
        }
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed(seed.getBytes());
        keygen.initialize(1024, secureRandom);
        KeyPair keys = keygen.genKeyPair();
        PublicKey publicKey = keys.getPublic();
        PrivateKey privateKey = keys.getPrivate();
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("AsymmetricEncryptorPublicKey", publicKey);
        map.put("AsymmetricEncryptorPrivateKey", privateKey);
        return map;
    }

    public static void main(String[] args) throws Exception {
        String inputStr = "RSA\u52a0\u5bc6\u5b57\u7b26\u4e32\u6d4b\u8bd5by-jiucai";
        byte[] data = inputStr.getBytes();
        String algorithmSeed = DSA.class.getName() + ".rsa.by.jiucai.20140705";
        Map<String, Object> keyMap = RSA.initKey(algorithmSeed);
        String publicKey = RSA.getPublicKey(keyMap);
        String privateKey = RSA.getPrivateKey(keyMap);
        System.out.println("\u516c\u94a5:\r" + publicKey);
        System.out.println("\u79c1\u94a5:\r" + privateKey);
        String sign = RSA.sign(data, privateKey);
        System.out.println("\u7b7e\u540d:\r" + sign);
        boolean status = RSA.verify(data, publicKey, sign);
        System.out.println("\u72b6\u6001:\r" + status);
    }

    public static String sign(byte[] data, String privateKey) {
        try {
            byte[] keyBytes = Base64.decode(privateKey);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(algorithmKey);
            PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Signature signature = Signature.getInstance(algorithmSignatureKey);
            signature.initSign(priKey);
            signature.update(data);
            return Base64.encode(signature.sign());
        }
        catch (Throwable e) {
            log.error("sign failed", e);
            return null;
        }
    }

    public static boolean verify(byte[] data, String publicKey, String sign) {
        try {
            log.info("using algorithmKey: RSA , algorithmSignatureKey: MD5withRSA");
            byte[] keyBytes = Base64.decode(publicKey);
            if (null == keyBytes) {
                log.error("invalid Base64 publicKey.");
                return false;
            }
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(algorithmKey);
            PublicKey pubKey = keyFactory.generatePublic(keySpec);
            Signature signature = Signature.getInstance(algorithmSignatureKey);
            signature.initVerify(pubKey);
            signature.update(data);
            byte[] signVal = Base64.decode(sign);
            if (null != signVal) {
                return signature.verify(signVal);
            }
            log.error("invalid Base64 sign.");
            return false;
        }
        catch (Throwable e) {
            log.error("verify failed", e);
            return false;
        }
    }
}

