/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.encrypt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.openpgp.bc.BcPGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.jiucai.appframework.common.encrypt.AbstractPGPEncryptor;

public class PGPDecryptor
extends AbstractPGPEncryptor {
    public static String decrypt(String passphrase, String keyFile, String encryptedStr) throws Exception {
        byte[] decrypted = PGPDecryptor.decryptByte(passphrase, keyFile, encryptedStr.getBytes());
        return new String(decrypted);
    }

    public static String decryptFile(String passphrase, String keyFile, String inputFile) throws Exception {
        byte[] encFromFile = PGPDecryptor.getBytesFromFile(new File(inputFile));
        byte[] decrypted = PGPDecryptor.decryptByte(passphrase, keyFile, encFromFile);
        return new String(decrypted);
    }

    private static PGPPrivateKey extractPrivateKey(PGPSecretKey pgpSecKey, char[] passPhrase) throws PGPException {
        PGPPrivateKey privateKey = null;
        BcPGPDigestCalculatorProvider calculatorProvider = new BcPGPDigestCalculatorProvider();
        BcPBESecretKeyDecryptorBuilder secretKeyDecryptorBuilder = new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)calculatorProvider);
        PBESecretKeyDecryptor pBESecretKeyDecryptor = secretKeyDecryptorBuilder.build(passPhrase);
        try {
            privateKey = pgpSecKey.extractPrivateKey(pBESecretKeyDecryptor);
        }
        catch (PGPException e) {
            throw new PGPException("invalid privateKey passPhrase: " + String.valueOf(passPhrase), (Exception)((Object)e));
        }
        return privateKey;
    }

    protected static byte[] decrypt(byte[] encrypted, InputStream keyIn, char[] password) throws IOException, PGPException, NoSuchProviderException {
        int ch;
        InputStream decodeIn = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(encrypted));
        BcPGPObjectFactory pgpF = new BcPGPObjectFactory(decodeIn);
        decodeIn.close();
        PGPEncryptedDataList enc = null;
        Object o = pgpF.nextObject();
        enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)pgpF.nextObject();
        PGPPrivateKey sKey = null;
        Iterator it = enc.getEncryptedDataObjects();
        PGPPublicKeyEncryptedData pbe = null;
        BcPGPSecretKeyRingCollection pgpSec = new BcPGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyIn));
        while (sKey == null && it.hasNext()) {
            pbe = (PGPPublicKeyEncryptedData)it.next();
            sKey = PGPDecryptor.findSecretKey((PGPSecretKeyRingCollection)pgpSec, pbe.getKeyID(), password);
        }
        if (pbe == null) {
            throw new IllegalArgumentException("PGPPublicKeyEncryptedData not found.");
        }
        if (sKey == null) {
            throw new IllegalArgumentException("secret key for message not found.");
        }
        BcPublicKeyDataDecryptorFactory pkdf = new BcPublicKeyDataDecryptorFactory(sKey);
        InputStream clear = pbe.getDataStream((PublicKeyDataDecryptorFactory)pkdf);
        BcPGPObjectFactory pgpFact = new BcPGPObjectFactory(clear);
        PGPCompressedData cData = (PGPCompressedData)pgpFact.nextObject();
        pgpFact = new BcPGPObjectFactory(cData.getDataStream());
        PGPLiteralData ld = (PGPLiteralData)pgpFact.nextObject();
        InputStream unc = ld.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((ch = unc.read()) >= 0) {
            out.write(ch);
        }
        byte[] returnBytes = out.toByteArray();
        clear.close();
        out.close();
        unc.close();
        return returnBytes;
    }

    protected static byte[] decryptByte(String passphrase, String keyFile, byte[] encryptedBytes) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        FileInputStream secKey = new FileInputStream(keyFile);
        byte[] decrypted = PGPDecryptor.decrypt(encryptedBytes, secKey, passphrase.toCharArray());
        return decrypted;
    }

    protected static PGPPrivateKey findSecretKey(PGPSecretKeyRingCollection pgpSec, long keyID, char[] pass) throws PGPException, NoSuchProviderException {
        PGPPrivateKey privateKey = null;
        PGPSecretKey pgpSecKey = pgpSec.getSecretKey(keyID);
        if (pgpSecKey == null) {
            return null;
        }
        privateKey = PGPDecryptor.extractPrivateKey(pgpSecKey, pass);
        return privateKey;
    }
}

