/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.mail;

import java.io.Serializable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jiucai.appframework.base.util.ConfigUtil;
import org.jiucai.appframework.base.util.LocalIPUtil;
import org.jiucai.appframework.common.mail.MailSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailThread
implements Runnable,
Serializable {
    private static final long serialVersionUID = -6405111041020961222L;
    protected static Logger log = LoggerFactory.getLogger(MailSender.class);
    private static String fromTitle;
    private static String mailFrom;
    private String[] mailTo;
    private String title;
    private String message;
    private String mailTemplate;

    protected static String getDefaultMailTemplate(String title, String message) {
        StringBuffer sb = new StringBuffer("<div style=\"font-size:12px; color: #000000; background-color: #fbfce4; border: 1px solid #eeeeee;\" >\n");
        sb.append("<h1 style=\"font-size: 14px; font-weight:bold;\">").append(title).append("</h1>\n");
        sb.append("<br/>\n");
        sb.append("<pre style=\"white-space:pre-wrap;white-space:-moz-pre-wrap;white-space:-pre-wrap;white-space:-o-pre-wrap;word-wrap:break-word;\">\n");
        sb.append(message);
        sb.append("</pre>\n");
        sb.append("<br/>\n");
        sb.append("<br/>\n------");
        sb.append("<br/>\n");
        sb.append("<br/>\n\u90ae\u4ef6\u6765\u6e90 : ");
        sb.append(LocalIPUtil.getLocalIP());
        sb.append("<br/>\n");
        sb.append("<br/>\n");
        sb.append("</div>\n");
        return sb.toString();
    }

    public MailThread() {
    }

    public MailThread(String[] mailAdds, String title, String message) {
        this.title = title;
        this.mailTo = mailAdds;
        this.message = message;
    }

    public String getMailTemplate() {
        if (StringUtils.isBlank((String)this.mailTemplate)) {
            this.mailTemplate = MailThread.getDefaultMailTemplate(this.title, this.message);
        }
        return this.mailTemplate;
    }

    public String[] getMailTo() {
        return this.mailTo;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public void run() {
        try {
            MailSender sender = new MailSender();
            String mailContent = MailThread.getDefaultMailTemplate(this.title, this.message);
            sender.sendMailAsHtml(fromTitle, mailFrom, null, this.mailTo, null, this.title, mailContent);
            log.info("mail sent successed:" + this.title);
        }
        catch (Exception e) {
            log.error("send mail error: " + ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    public void setMailTemplate(String mailTemplate) {
        this.mailTemplate = mailTemplate;
    }

    public void setMailTo(String[] mailTo) {
        this.mailTo = mailTo;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    static {
        Configuration config = ConfigUtil.addConfig("mail");
        fromTitle = config.getString("mail.from_name");
        mailFrom = config.getString("mail.from_mail");
    }
}

