/*
 * Decompiled with CFR 0.152.
 */
package org.jledit.command.file;

import java.io.File;
import java.io.IOException;
import org.jledit.ConsoleEditor;
import org.jledit.command.Command;
import org.jledit.command.undo.UndoContext;
import org.jledit.command.undo.UndoContextAware;

public class FileOpenCommand
implements Command,
UndoContextAware {
    private final ConsoleEditor editor;
    private final String fileName;
    private UndoContext undoContext;

    public FileOpenCommand(ConsoleEditor editor, String fileName) {
        this.editor = editor;
        this.fileName = fileName;
    }

    @Override
    public void execute() {
        if (this.editor.isOpenEnabled()) {
            try {
                boolean doOpen;
                if (this.editor.isDirty().booleanValue() && !(doOpen = this.editor.readBoolean("You have unsaved changes. Do you want to open a new file without saving? [y/N]", false))) {
                    return;
                }
                if (this.fileName == null || this.fileName.isEmpty()) {
                    String f = this.editor.readLine("Open file:");
                    this.undoContext.clear();
                    this.editor.open(new File(f));
                    this.editor.redrawText();
                    this.editor.redrawHeader();
                    this.editor.redrawFooter();
                } else {
                    this.undoContext.clear();
                    this.editor.open(new File(this.fileName));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setUndoContext(UndoContext undoContext) {
        this.undoContext = undoContext;
    }
}

