/*
 * Decompiled with CFR 0.152.
 */
package org.jledit.utils.internal;

import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import org.jledit.utils.Closeables;
import org.mozilla.universalchardet.UniversalDetector;

public final class Charsets {
    static final int BUFFER_SIZE = 4096;

    private Charsets() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset detect(File file) {
        FileInputStream fis = null;
        UniversalDetector detector = new UniversalDetector(null);
        try {
            int nread;
            byte[] buf = new byte[4096];
            fis = new FileInputStream(file);
            while ((nread = fis.read(buf)) > 0 && !detector.isDone()) {
                detector.handleData(buf, 0, nread);
            }
            detector.dataEnd();
            Charset charset = Charset.forName(detector.getDetectedCharset());
            Closeables.closeQuitely(fis);
            return charset;
        }
        catch (Exception e) {
            Charset charset = Charset.defaultCharset();
            return charset;
        }
        finally {
            Closeables.closeQuitely(fis);
        }
    }
}

