/*
 * Decompiled with CFR 0.152.
 */
package org.jledit;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import jline.Terminal;
import org.jledit.ConsoleEditor;
import org.jledit.EditorFactory;
import org.jledit.EditorInitializationException;
import org.jledit.utils.Resources;

public class ConcreteEditorFactory
implements EditorFactory {
    private static final String DEFAULT_FLAVOR = "simple";
    private static final String RESOURCE_PATH = "META-INF/services/org/jledit/";
    private final Map<String, Class<? extends ConsoleEditor>> flavorMap = new HashMap<String, Class<? extends ConsoleEditor>>();

    @Override
    public ConsoleEditor create() throws EditorInitializationException {
        return this.create(DEFAULT_FLAVOR);
    }

    @Override
    public ConsoleEditor create(Terminal terminal) throws EditorInitializationException {
        return this.create(DEFAULT_FLAVOR, terminal);
    }

    @Override
    public ConsoleEditor create(String flavor) throws EditorInitializationException {
        return this.create(flavor, null);
    }

    @Override
    public ConsoleEditor create(String flavor, Terminal terminal) throws EditorInitializationException {
        if (this.flavorMap.containsKey(flavor)) {
            Class<? extends ConsoleEditor> editorClass = this.flavorMap.get(flavor);
            try {
                return this.instantiate(editorClass, terminal);
            }
            catch (Exception e) {
                throw new EditorInitializationException("Failed to create Editor instance of class:" + editorClass.getName(), e);
            }
        }
        Class<? extends ConsoleEditor> editorClass = this.resolve(flavor);
        if (editorClass != null) {
            this.flavorMap.put(flavor, editorClass);
            return this.create(flavor, terminal);
        }
        throw new EditorInitializationException("Unknown flavor:" + flavor);
    }

    private Class<? extends ConsoleEditor> resolve(String flavor) throws EditorInitializationException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Enumeration<URL> urls = classLoader.getResources(RESOURCE_PATH + flavor);
            while (urls.hasMoreElements()) {
                String[] jleditClasses;
                URL url = urls.nextElement();
                String txt = Resources.toString(url);
                for (String jleditClass : jleditClasses = txt.split("\n")) {
                    Class<?> clazz;
                    if (jleditClass.isEmpty() || !ConsoleEditor.class.isAssignableFrom(clazz = classLoader.loadClass(jleditClass))) continue;
                    return clazz;
                }
            }
        }
        catch (Exception e) {
            throw new EditorInitializationException(e);
        }
        throw new EditorInitializationException("No Editor found for flavor:" + flavor);
    }

    private ConsoleEditor instantiate(Class<? extends ConsoleEditor> editorClass, Terminal terminal) throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        Constructor<? extends ConsoleEditor> constructor = editorClass.getConstructor(Terminal.class);
        return constructor.newInstance(terminal);
    }

    @Override
    public void bind(String flavor, Class<? extends ConsoleEditor> editorClass) {
        this.flavorMap.put(flavor, editorClass);
    }

    @Override
    public void unbind(String flavor) {
        this.flavorMap.remove(flavor);
    }
}

