/*
 * Decompiled with CFR 0.152.
 */
package org.jledit.command.editor;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import org.jledit.ConsoleEditor;
import org.jledit.command.editor.AbstractUndoableCommand;

public class PasteCommand
extends AbstractUndoableCommand {
    private final String clipboardContent = this.getClipboardContent();

    public PasteCommand(ConsoleEditor editor) {
        super(editor);
    }

    @Override
    public void doExecute() {
        if (!this.getEditor().isReadOnly() && !this.clipboardContent.isEmpty()) {
            this.getEditor().setDirty(true);
            this.getEditor().put(this.clipboardContent);
        }
    }

    @Override
    public void undo() {
        if (!this.getEditor().isReadOnly()) {
            this.getEditor().move(this.getBeforeLine(), this.getBeforeColumn());
            for (int i = 0; i < this.clipboardContent.length(); ++i) {
                this.getEditor().delete();
            }
        }
    }

    public final String getClipboardContent() {
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            result = (String)clipboard.getData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

