/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.search.extraction;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.jlibrary.core.search.extraction.ExtractionException;
import org.jlibrary.core.search.extraction.Extractor;
import org.jlibrary.core.search.extraction.HeaderMetaData;
import org.jlibrary.core.search.extraction.MSOfficeExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExtractor
extends MSOfficeExtractor
implements POIFSReaderListener,
Extractor {
    static Logger logger = LoggerFactory.getLogger((Class)(class$org$jlibrary$core$search$extraction$ExcelExtractor == null ? (class$org$jlibrary$core$search$extraction$ExcelExtractor = ExcelExtractor.class$("org.jlibrary.core.search.extraction.ExcelExtractor")) : class$org$jlibrary$core$search$extraction$ExcelExtractor));
    static /* synthetic */ Class class$org$jlibrary$core$search$extraction$ExcelExtractor;

    public String extractText(File f) throws ExtractionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            String string = this.extractText(fis);
            return string;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (ExtractionException ee) {
            throw ee;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new ExtractionException(e);
                }
            }
        }
    }

    public HeaderMetaData extractHeader(InputStream is) throws ExtractionException {
        try {
            POIFSReader reader = new POIFSReader();
            reader.registerListener((POIFSReaderListener)this);
            reader.read(this.getStreamCopy(is));
            return this.extractMetaInformation();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
    }

    public HeaderMetaData extractHeader(File f) throws ExtractionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            HeaderMetaData headerMetaData = this.extractHeader(fis);
            return headerMetaData;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (ExtractionException ee) {
            throw ee;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new ExtractionException(e);
                }
            }
        }
    }

    public String extractText(InputStream in) throws ExtractionException {
        String result;
        try {
            result = this.extractTableContent(this.getStreamCopy(in));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        result = this.removeControlChars(result);
        return result;
    }

    protected String extractTableContent(InputStream in) throws IOException {
        HSSFWorkbook excelWb = new HSSFWorkbook(in);
        StringBuilder result = new StringBuilder(4096);
        int numberOfSheets = excelWb.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            HSSFSheet sheet = excelWb.getSheetAt(i);
            int numberOfRows = sheet.getPhysicalNumberOfRows();
            if (numberOfRows <= 0) continue;
            if (excelWb.getSheetName(i) != null && !excelWb.getSheetName(i).equals("")) {
                if (i > 0) {
                    result.append("\n\n");
                }
                result.append(excelWb.getSheetName(i).trim());
                result.append(":\n\n");
            }
            Iterator rowIt = sheet.rowIterator();
            while (rowIt.hasNext()) {
                HSSFRow row = (HSSFRow)rowIt.next();
                if (row == null) continue;
                boolean hasContent = false;
                Iterator it = row.cellIterator();
                while (it.hasNext()) {
                    HSSFCell cell = (HSSFCell)it.next();
                    String text = null;
                    try {
                        switch (cell.getCellType()) {
                            case 3: 
                            case 5: {
                                break;
                            }
                            case 0: {
                                text = Double.toString(cell.getNumericCellValue());
                                break;
                            }
                            case 4: {
                                text = Boolean.toString(cell.getBooleanCellValue());
                                break;
                            }
                            default: {
                                text = cell.getStringCellValue();
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (text == null || text.equals("")) continue;
                    result.append(text.trim());
                    result.append(' ');
                    hasContent = true;
                }
                if (!hasContent) continue;
                result.append('\n');
            }
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

