/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.search.extraction;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.List;
import org.htmlparser.util.ParserException;
import org.jlibrary.core.entities.Directory;
import org.jlibrary.core.search.extraction.ExtractionException;
import org.jlibrary.core.search.extraction.Extractor;
import org.jlibrary.core.search.extraction.HeaderMetaData;
import org.jlibrary.core.search.extraction.html.HTMLParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTMLExtractor
implements Extractor {
    static Logger logger = LoggerFactory.getLogger((Class)(class$org$jlibrary$core$search$extraction$HTMLExtractor == null ? (class$org$jlibrary$core$search$extraction$HTMLExtractor = HTMLExtractor.class$("org.jlibrary.core.search.extraction.HTMLExtractor")) : class$org$jlibrary$core$search$extraction$HTMLExtractor));
    static /* synthetic */ Class class$org$jlibrary$core$search$extraction$HTMLExtractor;

    public String extractText(File f) throws ExtractionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            String string = this.extractText(fis);
            return string;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (ExtractionException ee) {
            throw ee;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new ExtractionException(e);
                }
            }
        }
    }

    public String extractText(InputStream is) throws ExtractionException {
        try {
            String text = HTMLParser.extractText(is, "iso-8859-1");
            return text;
        }
        catch (ParserException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
    }

    public Reader getReader(File f) throws ExtractionException {
        throw new ExtractionException("HTMLExtractor can't use getReader() method");
    }

    public HeaderMetaData extractHeader(File f) throws ExtractionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            HeaderMetaData headerMetaData = this.extractHeader(fis);
            return headerMetaData;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (ExtractionException ee) {
            throw ee;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new ExtractionException(e);
                }
            }
        }
    }

    public HeaderMetaData extractHeader(InputStream is) throws ExtractionException {
        try {
            HeaderMetaData header = HTMLParser.extractHeader(is, "iso-8859-1");
            return header;
        }
        catch (ParserException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
    }

    public String[] extractResources(File f) throws ExtractionException {
        try {
            FileInputStream fis = new FileInputStream(f);
            String[] paths = HTMLParser.extractResourcePaths(fis, "iso-8859-1");
            fis.close();
            return paths;
        }
        catch (ParserException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
    }

    public void changePaths(File f, Directory directory, List resources) throws ExtractionException {
        try {
            FileInputStream fis = new FileInputStream(f);
            HTMLParser.setLocalPaths(f, "iso-8859-1", directory, resources);
            fis.close();
        }
        catch (ParserException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
    }

    public String[] extractResources(URL url) throws ExtractionException {
        try {
            InputStream is = url.openStream();
            String[] resources = HTMLParser.extractResourcePaths(is, "iso-8859-1");
            is.close();
            return resources;
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage(), (Throwable)ioe);
            throw new ExtractionException(ioe);
        }
        catch (ParserException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

