/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.search.extraction;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.Section;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.jlibrary.core.search.extraction.HeaderMetaData;

public class MSOfficeExtractor {
    protected static final String ENCODING_CP1252 = "Cp1252";
    protected static final String ENCODING_UTF16 = "UTF-16";
    protected static final String POWERPOINT_EVENT_NAME = "PowerPoint Document";
    protected static final int PPT_TEXTBYTE_ATOM = 4008;
    protected static final int PPT_TEXTCHAR_ATOM = 4000;
    private DocumentSummaryInformation m_documentSummary;
    private SummaryInformation m_summary;
    protected byte[] m_inputBuffer;

    public void processPOIFSReaderEvent(POIFSReaderEvent event) {
        try {
            if (event.getName().startsWith("\u0005SummaryInformation")) {
                this.m_summary = (SummaryInformation)PropertySetFactory.create((InputStream)event.getStream());
                return;
            }
            if (event.getName().startsWith("\u0005DocumentSummaryInformation")) {
                this.m_documentSummary = (DocumentSummaryInformation)PropertySetFactory.create((InputStream)event.getStream());
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected HeaderMetaData extractMetaInformation() {
        String meta;
        Section section;
        HeaderMetaData metadata = new HeaderMetaData();
        if (this.m_summary != null) {
            Date date;
            section = (Section)this.m_summary.getSections().get(0);
            meta = (String)section.getProperty(2);
            if (meta != null && !meta.equals("")) {
                metadata.setTitle(meta);
                metadata.setDescription(meta);
            }
            if ((meta = (String)section.getProperty(5)) != null && !meta.equals("")) {
                metadata.setKeywords(meta);
            }
            if ((meta = (String)section.getProperty(3)) != null && !meta.equals("")) {
                metadata.setDescription(meta);
            }
            if ((meta = (String)section.getProperty(6)) == null || !meta.equals("")) {
                // empty if block
            }
            if ((meta = (String)section.getProperty(4)) != null && !meta.equals("")) {
                metadata.setAuthor(meta);
            }
            if ((date = (Date)section.getProperty(12)) == null || date.getTime() > 0L) {
                // empty if block
            }
            if ((date = (Date)section.getProperty(13)) == null || date.getTime() > 0L) {
                // empty if block
            }
        }
        if (this.m_documentSummary != null) {
            section = (Section)this.m_documentSummary.getSections().get(0);
            meta = (String)section.getProperty(15);
            if (meta == null || !meta.equals("")) {
                // empty if block
            }
            if ((meta = (String)section.getProperty(14)) == null || !meta.equals("")) {
                // empty if block
            }
            if ((meta = (String)section.getProperty(2)) == null || !meta.equals("")) {
                // empty if block
            }
        }
        return metadata;
    }

    protected String removeControlChars(String content) {
        char[] chars = content.toCharArray();
        StringBuffer result = new StringBuffer(chars.length);
        boolean wasUnwanted = false;
        block4: for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            int type = Character.getType(ch);
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 12: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 26: 
                case 29: 
                case 30: {
                    result.append(ch);
                    wasUnwanted = false;
                    continue block4;
                }
                case 13: {
                    result.append('\n');
                    wasUnwanted = true;
                    continue block4;
                }
                default: {
                    if (wasUnwanted) continue block4;
                    result.append('\n');
                    wasUnwanted = true;
                }
            }
        }
        return result.toString();
    }

    public InputStream getStreamCopy(InputStream in) throws IOException {
        if (this.m_inputBuffer != null) {
            return new ByteArrayInputStream(this.m_inputBuffer);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        int c = 0;
        while ((c = in.read()) >= 0) {
            out.write(c);
        }
        this.m_inputBuffer = out.toByteArray();
        return new ByteArrayInputStream(this.m_inputBuffer);
    }
}

