/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.search.extraction;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jlibrary.core.search.extraction.ExtractionException;
import org.jlibrary.core.search.extraction.Extractor;
import org.jlibrary.core.search.extraction.HeaderMetaData;
import org.jlibrary.core.search.extraction.xml.OOoContentHandler;
import org.jlibrary.core.search.extraction.xml.OOoMetaHandler;
import org.jlibrary.core.util.zip.ZipEntry;
import org.jlibrary.core.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class OOoExtractor
implements Extractor {
    static Logger logger = LoggerFactory.getLogger((Class)(class$org$jlibrary$core$search$extraction$OOoExtractor == null ? (class$org$jlibrary$core$search$extraction$OOoExtractor = OOoExtractor.class$("org.jlibrary.core.search.extraction.OOoExtractor")) : class$org$jlibrary$core$search$extraction$OOoExtractor));
    private static String CONTENT_FILE = "content.xml";
    private static String META_FILE = "meta.xml";
    private static String DATE_FORMAT = "yyyy-MM-DD'T'HH:mm:ss";
    private XMLReader xmlReader;
    static /* synthetic */ Class class$org$jlibrary$core$search$extraction$OOoExtractor;

    public OOoExtractor() throws ExtractionException {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            this.xmlReader = saxParser.getXMLReader();
            this.xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            this.xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Exception e) {
            throw new ExtractionException(e);
        }
    }

    public String extractText(File f) throws ExtractionException {
        InputStream contentStream = null;
        try {
            ZipFile zf = new ZipFile(f);
            ZipEntry ze = zf.getEntry(CONTENT_FILE);
            contentStream = zf.getInputStream(ze);
            String string = this.extractText(contentStream);
            return string;
        }
        catch (Exception e) {
            throw new ExtractionException(e);
        }
        finally {
            if (contentStream != null) {
                try {
                    contentStream.close();
                }
                catch (IOException ioe) {
                    logger.error(ioe.getMessage(), (Throwable)ioe);
                }
            }
        }
    }

    public String extractText(InputStream contentStream) throws ExtractionException {
        try {
            OOoContentHandler contentHandler = new OOoContentHandler();
            this.xmlReader.setContentHandler(contentHandler);
            this.xmlReader.parse(new InputSource(contentStream));
            contentStream.close();
            return contentHandler.getContent();
        }
        catch (Exception e) {
            throw new ExtractionException(e);
        }
    }

    public HeaderMetaData extractHeader(File f) throws ExtractionException {
        InputStream metaStream = null;
        try {
            ZipFile zf = new ZipFile(f);
            ZipEntry ze = zf.getEntry(META_FILE);
            metaStream = zf.getInputStream(ze);
            HeaderMetaData headerMetaData = this.extractHeader(metaStream);
            return headerMetaData;
        }
        catch (Exception e) {
            throw new ExtractionException(e);
        }
        finally {
            if (metaStream != null) {
                try {
                    metaStream.close();
                }
                catch (IOException ioe) {
                    logger.error(ioe.getMessage(), (Throwable)ioe);
                }
            }
        }
    }

    public HeaderMetaData extractHeader(InputStream metaStream) throws ExtractionException {
        HeaderMetaData metadata = new HeaderMetaData();
        try {
            OOoMetaHandler metaHandler = new OOoMetaHandler();
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
            this.xmlReader.setContentHandler(metaHandler);
            this.xmlReader.parse(new InputSource(metaStream));
            metadata.setAuthor(metaHandler.getCreator());
            metadata.setDate(df.parse(metaHandler.getCreationDate()));
            metadata.setDescription(metaHandler.getDescription());
            metadata.setKeywords(metaHandler.getKeywords());
            String lang = metaHandler.getLanguage();
            if (lang != null && !lang.equals("")) {
                metadata.setLanguage(lang.substring(0, lang.indexOf("-")));
            }
            metadata.setTitle(metaHandler.getTitle());
            metaStream.close();
        }
        catch (Exception e) {
            throw new ExtractionException(e);
        }
        return metadata;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

