/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.search.extraction;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.jlibrary.core.search.extraction.ExtractionException;
import org.jlibrary.core.search.extraction.Extractor;
import org.jlibrary.core.search.extraction.HeaderMetaData;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFExtractor
implements Extractor {
    static Logger logger = LoggerFactory.getLogger((Class)(class$org$jlibrary$core$search$extraction$PDFExtractor == null ? (class$org$jlibrary$core$search$extraction$PDFExtractor = PDFExtractor.class$("org.jlibrary.core.search.extraction.PDFExtractor")) : class$org$jlibrary$core$search$extraction$PDFExtractor));
    static /* synthetic */ Class class$org$jlibrary$core$search$extraction$PDFExtractor;

    public String extractText(File f) throws ExtractionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            String string = this.extractText(fis);
            return string;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (ExtractionException ee) {
            throw ee;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new ExtractionException(e);
                }
            }
        }
    }

    public String extractText(InputStream is) throws ExtractionException {
        try {
            PDDocument pdDocument = PDDocument.load((InputStream)is);
            PDFTextStripper stripper = new PDFTextStripper();
            StringWriter writer = new StringWriter();
            stripper.writeText(pdDocument, (Writer)writer);
            pdDocument.close();
            return writer.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
    }

    public Reader getReader(File f) throws ExtractionException {
        throw new ExtractionException("PDFExtractor can't use getReader() method");
    }

    public HeaderMetaData extractHeader(File f) throws ExtractionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            HeaderMetaData headerMetaData = this.extractHeader(fis);
            return headerMetaData;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (ExtractionException ee) {
            throw ee;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new ExtractionException(e);
                }
            }
        }
    }

    public HeaderMetaData extractHeader(InputStream is) throws ExtractionException {
        HeaderMetaData metadata = new HeaderMetaData();
        PDFParser parser = null;
        try {
            parser = new PDFParser(is);
            parser.parse();
            if (parser.getPDDocument().getDocumentInformation().getAuthor() != null) {
                metadata.setAuthor(parser.getPDDocument().getDocumentInformation().getAuthor());
            }
            if (parser.getPDDocument().getDocumentInformation().getCreationDate() != null) {
                metadata.setDate(parser.getPDDocument().getDocumentInformation().getCreationDate().getTime());
            }
            if (parser.getPDDocument().getDocumentInformation().getKeywords() != null) {
                metadata.setKeywords(parser.getPDDocument().getDocumentInformation().getKeywords());
            }
            if (parser.getPDDocument().getDocumentInformation().getTitle() != null) {
                metadata.setTitle(parser.getPDDocument().getDocumentInformation().getTitle());
            }
            parser.getPDDocument().close();
        }
        catch (Exception e) {
            throw new ExtractionException(e);
        }
        return metadata;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

