/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.search.extraction;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.util.LittleEndian;
import org.jlibrary.core.search.extraction.ExtractionException;
import org.jlibrary.core.search.extraction.Extractor;
import org.jlibrary.core.search.extraction.HeaderMetaData;
import org.jlibrary.core.search.extraction.MSOfficeExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerPointExtractor
extends MSOfficeExtractor
implements POIFSReaderListener,
Extractor {
    static Logger logger = LoggerFactory.getLogger((Class)(class$org$jlibrary$core$search$extraction$PowerPointExtractor == null ? (class$org$jlibrary$core$search$extraction$PowerPointExtractor = PowerPointExtractor.class$("org.jlibrary.core.search.extraction.PowerPointExtractor")) : class$org$jlibrary$core$search$extraction$PowerPointExtractor));
    protected static final String ENCODING_CP1252 = "Cp1252";
    protected static final String ENCODING_UTF16 = "UTF-16";
    protected static final String POWERPOINT_EVENT_NAME = "PowerPoint Document";
    protected static final int PPT_TEXTBYTE_ATOM = 4008;
    protected static final int PPT_TEXTCHAR_ATOM = 4000;
    private StringBuffer m_buffer = new StringBuffer(4096);
    static /* synthetic */ Class class$org$jlibrary$core$search$extraction$PowerPointExtractor;

    public String extractText(File f) throws ExtractionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            String string = this.extractText(fis);
            return string;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (ExtractionException ee) {
            throw ee;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new ExtractionException(e);
                }
            }
        }
    }

    public HeaderMetaData extractHeader(File f) throws ExtractionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            HeaderMetaData headerMetaData = this.extractHeader(fis);
            return headerMetaData;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (ExtractionException ee) {
            throw ee;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new ExtractionException(e);
                }
            }
        }
    }

    public HeaderMetaData extractHeader(InputStream is) throws ExtractionException {
        try {
            POIFSReader reader = new POIFSReader();
            reader.registerListener((POIFSReaderListener)this);
            reader.read(is);
            return this.extractMetaInformation();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new ExtractionException(t);
        }
    }

    public String extractText(InputStream in) throws ExtractionException {
        POIFSReader reader = new POIFSReader();
        reader.registerListener((POIFSReaderListener)this);
        try {
            reader.read(in);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        String result = this.removeControlChars(this.m_buffer.toString());
        return result;
    }

    public void processPOIFSReaderEvent(POIFSReaderEvent event) {
        try {
            super.processPOIFSReaderEvent(event);
            if (!event.getName().startsWith(POWERPOINT_EVENT_NAME)) {
                return;
            }
            DocumentInputStream input = event.getStream();
            byte[] buffer = new byte[input.available()];
            input.read(buffer, 0, input.available());
            for (int i = 0; i < buffer.length - 20; ++i) {
                int type = LittleEndian.getUShort((byte[])buffer, (int)(i + 2));
                int size = (int)LittleEndian.getUInt((byte[])buffer, (int)(i + 4)) + 3;
                String encoding = null;
                switch (type) {
                    case 4008: {
                        encoding = ENCODING_CP1252;
                    }
                    case 4000: {
                        if (encoding == null) {
                            encoding = ENCODING_UTF16;
                        }
                        int start = i + 4 + 1;
                        int end = start + size;
                        byte[] buf = new byte[size];
                        System.arraycopy(buffer, start, buf, 0, buf.length);
                        this.m_buffer.append(new String(buf, encoding));
                        i = end;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: PowerPointExtractor file");
            System.exit(0);
        }
        try {
            File file = new File(args[0]);
            if (!file.exists()) {
                System.out.println("The specified file does not exist");
                System.exit(0);
            }
            System.out.println(new PowerPointExtractor().extractText(new FileInputStream(file)));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

