/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.search.extraction;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.jlibrary.core.search.extraction.ExtractionException;
import org.jlibrary.core.search.extraction.Extractor;
import org.jlibrary.core.search.extraction.HeaderMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTFExtractor
implements Extractor {
    static Logger logger = LoggerFactory.getLogger((Class)(class$org$jlibrary$core$search$extraction$RTFExtractor == null ? (class$org$jlibrary$core$search$extraction$RTFExtractor = RTFExtractor.class$("org.jlibrary.core.search.extraction.RTFExtractor")) : class$org$jlibrary$core$search$extraction$RTFExtractor));
    private RTFEditorKit rek = new RTFEditorKit();
    private DefaultStyledDocument doc = new DefaultStyledDocument();
    static /* synthetic */ Class class$org$jlibrary$core$search$extraction$RTFExtractor;

    public String extractText(File f) throws ExtractionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            String string = this.extractText(fis);
            return string;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (ExtractionException ee) {
            throw ee;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new ExtractionException(e);
                }
            }
        }
    }

    public String extractText(InputStream is) throws ExtractionException {
        try {
            this.doc.remove(0, this.doc.getLength());
            this.rek.read(is, (Document)this.doc, 0);
            return this.doc.getText(0, this.doc.getLength());
        }
        catch (Exception e) {
            throw new ExtractionException(e);
        }
    }

    public Reader getReader(File f) throws ExtractionException {
        throw new ExtractionException("RTFExtractor can't use getReader() method");
    }

    public HeaderMetaData extractHeader(File f) throws ExtractionException {
        HeaderMetaData metadata = new HeaderMetaData();
        return metadata;
    }

    public HeaderMetaData extractHeader(InputStream is) throws ExtractionException {
        HeaderMetaData metadata = new HeaderMetaData();
        return metadata;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

