/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.search.extraction;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jlibrary.core.search.extraction.ExtractionException;
import org.jlibrary.core.search.extraction.Extractor;
import org.jlibrary.core.search.extraction.HeaderMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextExtractor
implements Extractor {
    static Logger logger = LoggerFactory.getLogger((Class)(class$org$jlibrary$core$search$extraction$TextExtractor == null ? (class$org$jlibrary$core$search$extraction$TextExtractor = TextExtractor.class$("org.jlibrary.core.search.extraction.TextExtractor")) : class$org$jlibrary$core$search$extraction$TextExtractor));
    static /* synthetic */ Class class$org$jlibrary$core$search$extraction$TextExtractor;

    public String extractText(File f) throws ExtractionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            String string = this.extractText(fis);
            return string;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (ExtractionException ee) {
            throw ee;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new ExtractionException(e);
                }
            }
        }
    }

    public String extractText(InputStream is) throws ExtractionException {
        try {
            StringBuffer sb = new StringBuffer();
            byte[] buffer = new byte[1024];
            while (is.read(buffer) != -1) {
                sb.append(buffer);
            }
            is.close();
            return sb.toString();
        }
        catch (Exception e) {
            throw new ExtractionException(e);
        }
    }

    public String extractText(byte[] content) throws ExtractionException {
        try {
            InputStreamReader r = new InputStreamReader(new ByteArrayInputStream(content));
            StringBuffer sb = new StringBuffer();
            char[] buffer = new char[1024];
            while (r.read(buffer) != -1) {
                sb.append(buffer);
            }
            ((Reader)r).close();
            return sb.toString();
        }
        catch (Exception e) {
            throw new ExtractionException(e);
        }
    }

    public Reader getReader(File f) throws ExtractionException {
        try {
            return new FileReader(f);
        }
        catch (FileNotFoundException e) {
            throw new ExtractionException(e);
        }
    }

    public HeaderMetaData extractHeader(File f) throws ExtractionException {
        HeaderMetaData metadata = new HeaderMetaData();
        return metadata;
    }

    public HeaderMetaData extractHeader(InputStream is) throws ExtractionException {
        HeaderMetaData metadata = new HeaderMetaData();
        return metadata;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

