/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.search.extraction;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.jlibrary.core.search.extraction.ExtractionException;
import org.jlibrary.core.search.extraction.Extractor;
import org.jlibrary.core.search.extraction.HeaderMetaData;
import org.jlibrary.core.search.extraction.MSOfficeExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordExtractor
extends MSOfficeExtractor
implements Extractor,
POIFSReaderListener {
    static Logger logger = LoggerFactory.getLogger((Class)(class$org$jlibrary$core$search$extraction$WordExtractor == null ? (class$org$jlibrary$core$search$extraction$WordExtractor = WordExtractor.class$("org.jlibrary.core.search.extraction.WordExtractor")) : class$org$jlibrary$core$search$extraction$WordExtractor));
    org.textmining.text.extraction.WordExtractor extractor = new org.textmining.text.extraction.WordExtractor();
    static /* synthetic */ Class class$org$jlibrary$core$search$extraction$WordExtractor;

    public String extractText(File f) throws ExtractionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            String string = this.extractText(fis);
            return string;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (ExtractionException ee) {
            throw ee;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new ExtractionException(e);
                }
            }
        }
    }

    public String extractText(InputStream is) throws ExtractionException {
        try {
            String text = this.extractor.extractText(is);
            return text;
        }
        catch (Exception e) {
            throw new ExtractionException(e);
        }
    }

    public Reader getReader(File f) throws ExtractionException {
        throw new ExtractionException("WordExtractor can't use getReader() method");
    }

    public HeaderMetaData extractHeader(File f) throws ExtractionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            HeaderMetaData headerMetaData = this.extractHeader(fis);
            return headerMetaData;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (ExtractionException ee) {
            throw ee;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new ExtractionException(e);
                }
            }
        }
    }

    public HeaderMetaData extractHeader(InputStream is) throws ExtractionException {
        try {
            POIFSReader reader = new POIFSReader();
            reader.registerListener((POIFSReaderListener)this);
            reader.read(is);
            return this.extractMetaInformation();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

