/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.search.extraction;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.jlibrary.core.search.extraction.ExtractionException;
import org.jlibrary.core.search.extraction.Extractor;
import org.jlibrary.core.search.extraction.HeaderMetaData;
import org.jlibrary.core.search.extraction.xml.XMLParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.XMLReader;

public class XMLExtractor
implements Extractor {
    static Logger logger = LoggerFactory.getLogger((Class)(class$org$jlibrary$core$search$extraction$XMLExtractor == null ? (class$org$jlibrary$core$search$extraction$XMLExtractor = XMLExtractor.class$("org.jlibrary.core.search.extraction.XMLExtractor")) : class$org$jlibrary$core$search$extraction$XMLExtractor));
    private XMLParser parser;
    static /* synthetic */ Class class$org$jlibrary$core$search$extraction$XMLExtractor;

    public XMLExtractor() throws ExtractionException {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.parser = new XMLParser(xmlReader);
        }
        catch (Exception e) {
            throw new ExtractionException(e);
        }
    }

    public String extractText(File f) throws ExtractionException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            String string = this.extractText(fis);
            return string;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ExtractionException(e);
        }
        catch (ExtractionException ee) {
            throw ee;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new ExtractionException(e);
                }
            }
        }
    }

    public String extractText(InputStream is) throws ExtractionException {
        try {
            byte[] content = IOUtils.toByteArray((InputStream)is);
            this.parser.parse(content);
            return this.parser.getContents();
        }
        catch (Exception e) {
            throw new ExtractionException(e);
        }
    }

    public Reader getReader(File f) throws ExtractionException {
        throw new ExtractionException("XMLExtractor can't use getReader() method");
    }

    public HeaderMetaData extractHeader(File f) throws ExtractionException {
        HeaderMetaData metadata = new HeaderMetaData();
        return metadata;
    }

    public HeaderMetaData extractHeader(InputStream is) throws ExtractionException {
        HeaderMetaData metadata = new HeaderMetaData();
        return metadata;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

