/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.search.extraction.html;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.beans.StringBean;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.lexer.Stream;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.tags.ImageTag;
import org.htmlparser.tags.MetaTag;
import org.htmlparser.util.NodeIterator;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.htmlparser.visitors.NodeVisitor;
import org.htmlparser.visitors.TagFindingVisitor;
import org.jlibrary.core.entities.Directory;
import org.jlibrary.core.entities.ResourceNode;
import org.jlibrary.core.search.extraction.HeaderMetaData;
import org.jlibrary.core.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HTMLParser {
    static Logger logger = LoggerFactory.getLogger((Class)(class$org$jlibrary$core$search$extraction$html$HTMLParser == null ? (class$org$jlibrary$core$search$extraction$html$HTMLParser = HTMLParser.class$("org.jlibrary.core.search.extraction.html.HTMLParser")) : class$org$jlibrary$core$search$extraction$html$HTMLParser));
    static /* synthetic */ Class class$org$jlibrary$core$search$extraction$html$HTMLParser;
    static /* synthetic */ Class class$org$htmlparser$tags$ImageTag;

    private HTMLParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractText(String content, String encoding) throws ParserException, UnsupportedEncodingException {
        StringBuilder newContent = new StringBuilder(content.length() + 32);
        newContent.append("<html><body>");
        newContent.append(content);
        newContent.append("</body></html>");
        ByteArrayInputStream in = new ByteArrayInputStream(newContent.toString().getBytes(encoding));
        try {
            String string = HTMLParser.extractText(in, encoding);
            return string;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new ParserException((Throwable)e);
                }
            }
        }
    }

    public static String extractText(InputStream in, String encoding) throws ParserException, UnsupportedEncodingException {
        Parser parser = new Parser();
        Lexer lexer = new Lexer();
        Page page = new Page(in, encoding);
        lexer.setPage(page);
        parser.setLexer(lexer);
        StringBean stringBean = new StringBean();
        parser.visitAllNodesWith((NodeVisitor)stringBean);
        return stringBean.getStrings();
    }

    public static HeaderMetaData extractHeader(InputStream in, String encoding) throws ParserException, UnsupportedEncodingException {
        Parser parser = new Parser();
        Lexer lexer = new Lexer();
        Page page = new Page(in, encoding);
        lexer.setPage(page);
        parser.setLexer(lexer);
        String[] tagsToBeFound = new String[]{"META", "TITLE"};
        TagFindingVisitor visitor = new TagFindingVisitor(tagsToBeFound);
        parser.visitAllNodesWith((NodeVisitor)visitor);
        Node[] allMETATags = visitor.getTags(0);
        HeaderMetaData metadata = new HeaderMetaData();
        for (int i = 0; i < allMETATags.length; ++i) {
            MetaTag node = (MetaTag)allMETATags[i];
            String tagName = node.getMetaTagName();
            if (tagName == null) continue;
            if (tagName.equalsIgnoreCase("author")) {
                metadata.setAuthor(node.getMetaContent());
                continue;
            }
            if (tagName.equalsIgnoreCase("description")) {
                metadata.setDescription(node.getMetaContent());
                continue;
            }
            if (tagName.equalsIgnoreCase("keywords")) {
                metadata.setKeywords(node.getMetaContent());
                continue;
            }
            if (tagName.equalsIgnoreCase("title")) {
                metadata.setTitle(node.getMetaContent());
                continue;
            }
            if (!tagName.equalsIgnoreCase("language")) continue;
            metadata.setLanguage(node.getMetaContent());
        }
        Node[] titleTags = visitor.getTags(1);
        if (titleTags.length > 0) {
            metadata.setTitle(titleTags[0].toPlainTextString());
        }
        return metadata;
    }

    public static String[] extractResourcePaths(InputStream in, String encoding) throws ParserException, UnsupportedEncodingException {
        Parser parser = new Parser();
        Lexer lexer = new Lexer();
        Stream stream = new Stream(in);
        Page page = new Page((InputStream)stream, encoding);
        lexer.setPage(page);
        parser.setLexer(lexer);
        return HTMLParser.extractResourcePaths(parser);
    }

    public static void setLocalPaths(File file, String encoding, Directory directory, List resources) throws ParserException, UnsupportedEncodingException {
        try {
            Parser parser = new Parser();
            Lexer lexer = new Lexer();
            FileInputStream fis = new FileInputStream(file);
            Stream stream = new Stream((InputStream)fis);
            Page page = new Page((InputStream)stream, encoding);
            lexer.setPage(page);
            parser.setLexer(lexer);
            byte[] newContent = HTMLParser.setLocalPaths(parser, file, directory, resources);
            fis.close();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(newContent);
            fos.close();
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ParserException((Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ParserException((Throwable)e);
        }
    }

    private static String[] extractResourcePaths(Parser parser) throws ParserException, UnsupportedEncodingException {
        ArrayList<String> resources = new ArrayList<String>();
        NodeClassFilter filter = new NodeClassFilter(class$org$htmlparser$tags$ImageTag == null ? (class$org$htmlparser$tags$ImageTag = HTMLParser.class$("org.htmlparser.tags.ImageTag")) : class$org$htmlparser$tags$ImageTag);
        NodeList list = parser.extractAllNodesThatMatch((NodeFilter)filter);
        for (int i = 0; i < list.size(); ++i) {
            ImageTag tag = (ImageTag)list.elementAt(i);
            String location = tag.extractImageLocn();
            if (location.trim().equals("")) continue;
            location = StringUtils.replace((String)location, (String)"\"", (String)"");
            resources.add(location);
        }
        TagFindingVisitor visitor = new TagFindingVisitor(new String[]{"LINK"});
        parser.visitAllNodesWith((NodeVisitor)visitor);
        Node[] allTags = visitor.getTags(0);
        for (int i = 0; i < allTags.length; ++i) {
            TagNode tag = (TagNode)allTags[i];
            String href = tag.getAttribute("href");
            if (!href.endsWith(".css")) continue;
            resources.add(href);
        }
        return resources.toArray(new String[0]);
    }

    private static byte[] setLocalPaths(Parser parser, File file, Directory directory, List resources) throws ParserException, UnsupportedEncodingException {
        NodeList list = new NodeList();
        NodeIterator e = parser.elements();
        while (e.hasMoreNodes()) {
            Node node = e.nextNode();
            HTMLParser.processRecursively(parser, directory, resources, node);
            list.add(node);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos);
        for (int i = 0; i < list.size(); ++i) {
            out.print(list.elementAt(i).toHtml());
        }
        out.close();
        return baos.toByteArray();
    }

    private static void processRecursively(Parser parser, Directory directory, List resources, Node node) throws ParserException, UnsupportedEncodingException {
        NodeList list;
        if (node instanceof TagNode) {
            TagNode tag = (TagNode)node;
            if (tag.getTagName().equalsIgnoreCase("img")) {
                ImageTag imageTag = (ImageTag)tag;
                String location = imageTag.getImageURL();
                imageTag.setImageURL(HTMLParser.changeLocation(location, directory, resources));
            } else {
                String href = tag.getAttribute("href");
                if (href != null && href.endsWith(".css")) {
                    tag.setAttribute("href", HTMLParser.changeLocation(href, directory, resources));
                }
            }
        }
        if ((list = node.getChildren()) == null) {
            return;
        }
        SimpleNodeIterator e = list.elements();
        while (e.hasMoreNodes()) {
            HTMLParser.processRecursively(parser, directory, resources, e.nextNode());
        }
    }

    private static String changeLocation(String location, Directory directory, List resources) {
        String locationName = FileUtils.getFileName((String)location);
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            ResourceNode resource = (ResourceNode)it.next();
            if (!resource.getPath().endsWith(locationName)) continue;
            StringBuilder buffer = new StringBuilder();
            StringBuilder docPath = new StringBuilder(directory.getPath());
            StringBuilder resPath = new StringBuilder(resource.getPath());
            int k2 = resPath.lastIndexOf("/");
            resPath.delete(k2 + 1, resPath.length());
            while (docPath.length() > 0 && resPath.length() > 0 && docPath.charAt(0) == resPath.charAt(0)) {
                docPath.deleteCharAt(0);
                resPath.deleteCharAt(0);
            }
            if (docPath.length() == 0) {
                buffer.append("./");
                buffer.append(resPath.toString());
            } else {
                buffer.append("../");
                for (int i = 0; i < docPath.length(); ++i) {
                    if (docPath.charAt(i) != '/') continue;
                    buffer.append("../");
                }
                if (buffer.charAt(buffer.length() - 1) == '/') {
                    buffer.deleteCharAt(buffer.length() - 1);
                }
                buffer.append(resPath.toString());
            }
            buffer.append(locationName);
            return buffer.toString();
        }
        return location;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

