/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.search.extraction.html;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.htmlparser.Attribute;
import org.htmlparser.NodeFactory;
import org.htmlparser.Parser;
import org.htmlparser.PrototypicalNodeFactory;
import org.htmlparser.Tag;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.tags.BaseHrefTag;
import org.htmlparser.tags.FrameTag;
import org.htmlparser.tags.ImageTag;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.util.EncodingChangeException;
import org.htmlparser.util.NodeIterator;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.jlibrary.core.entities.Types;
import org.jlibrary.core.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTMLRipper {
    static Logger logger = LoggerFactory.getLogger((Class)(class$org$jlibrary$core$search$extraction$html$HTMLRipper == null ? (class$org$jlibrary$core$search$extraction$html$HTMLRipper = HTMLRipper.class$("org.jlibrary.core.search.extraction.html.HTMLRipper")) : class$org$jlibrary$core$search$extraction$html$HTMLRipper));
    private static Parser mParser;
    private static String mSource;
    private static HashSet resources;
    private static String resourcesDirectory;
    protected final int TRANSFER_SIZE = 4096;
    static /* synthetic */ Class class$org$jlibrary$core$search$extraction$html$HTMLRipper;

    public File crawlFile(File parent, String url) throws ParserException {
        if (mParser == null) {
            this.initParser();
        }
        return this.crawl(parent, url);
    }

    public File[] crawlFileWithResources(File parent, String url) throws ParserException {
        if (mParser == null) {
            this.initParser();
        }
        ArrayList<File> crawled = new ArrayList<File>();
        resources.clear();
        resourcesDirectory = this.getResourcesDirectory(url);
        File file = this.crawl(parent, url);
        crawled.add(file);
        if (resources.size() > 0) {
            File directory = new File(parent, resourcesDirectory);
            if (!directory.exists()) {
                directory.mkdir();
            }
            Iterator it = resources.iterator();
            while (it.hasNext()) {
                String resourceURL = (String)it.next();
                crawled.add(this.crawlResource(directory, resourceURL));
            }
        }
        return crawled.toArray(new File[0]);
    }

    private String getResourcesDirectory(String url) {
        String extension = FileUtils.getExtension((String)url);
        url = StringUtils.replace((String)url, (String)extension, (String)"");
        int i = url.lastIndexOf(47);
        url = url.substring(i + 1);
        int j = url.lastIndexOf(46);
        return url.substring(j + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File crawlResource(File parent, String url) {
        File file = null;
        if (logger.isDebugEnabled()) {
            logger.debug("[HTMLRipper] processing " + url);
        }
        try {
            URL source = new URL(url);
            file = new File(parent, this.makeLocalLink(url, url, ""));
            byte[] data = new byte[4096];
            try {
                InputStream in = source.openStream();
                try {
                    FileOutputStream out = new FileOutputStream(file);
                    try {
                        int read;
                        while (-1 != (read = in.read(data, 0, data.length))) {
                            out.write(data, 0, read);
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                catch (FileNotFoundException fnfe) {
                    logger.error(fnfe.getMessage(), (Throwable)fnfe);
                }
                finally {
                    in.close();
                }
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("broken link " + fnfe.getMessage() + " ignored");
            }
        }
        catch (MalformedURLException murle) {
            logger.error(murle.getMessage(), (Throwable)murle);
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage(), (Throwable)ioe);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File crawl(File parent, String url) throws ParserException {
        File file;
        block36: {
            mSource = url;
            NodeList list = null;
            file = null;
            File dir = null;
            PrintWriter out = null;
            try {
                file = new File(parent, this.makeLocalLink(url, url, ""));
                dir = file.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                } else if (!dir.isDirectory()) {
                    if (!(dir = new File(dir.getParentFile(), dir.getName() + ".content")).exists()) {
                        dir.mkdirs();
                    }
                    file = new File(dir, file.getName());
                }
                FileOutputStream fos = null;
                if (Types.isBrowsable((Integer)Types.getTypeForFile((String)file.getAbsolutePath()))) {
                    try {
                        mParser.setURL(url);
                        try {
                            list = new NodeList();
                            NodeIterator e = mParser.elements();
                            while (e.hasMoreNodes()) {
                                list.add(e.nextNode());
                            }
                        }
                        catch (EncodingChangeException ece) {
                            mParser.reset();
                            list = new NodeList();
                            NodeIterator e = mParser.elements();
                            while (e.hasMoreNodes()) {
                                list.add(e.nextNode());
                            }
                        }
                        fos = new FileOutputStream(file);
                        out = new PrintWriter(fos);
                        for (int i = 0; i < list.size(); ++i) {
                            out.print(list.elementAt(i).toHtml());
                        }
                        break block36;
                    }
                    catch (FileNotFoundException fnfe) {
                        logger.error(fnfe.getMessage(), (Throwable)fnfe);
                        break block36;
                    }
                    finally {
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (IOException ioe) {
                            logger.error(ioe.getMessage(), (Throwable)ioe);
                            throw new ParserException((Throwable)ioe);
                        }
                    }
                }
                InputStream stream = null;
                try {
                    stream = new URL(url).openStream();
                    fos = new FileOutputStream(file);
                    IOUtils.copy((InputStream)stream, (OutputStream)fos);
                }
                catch (IOException ioe) {
                    logger.error(ioe.getMessage(), (Throwable)ioe);
                    throw new ParserException((Throwable)ioe);
                }
                finally {
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException ioe) {
                        logger.error(ioe.getMessage(), (Throwable)ioe);
                        throw new ParserException((Throwable)ioe);
                    }
                }
            }
            catch (ParserException pe) {
                String message = pe.getMessage();
                if (null != message && message.endsWith("does not contain text")) break block36;
                throw pe;
            }
        }
        return file;
    }

    private void initParser() {
        mParser = new Parser();
        PrototypicalNodeFactory factory = new PrototypicalNodeFactory();
        factory.registerTag((Tag)new LocalLinkTag());
        factory.registerTag((Tag)new LocalFrameTag());
        factory.registerTag((Tag)new LocalBaseHrefTag());
        factory.registerTag((Tag)new LocalImageTag());
        factory.registerTag((Tag)new LocalMetaLinkTag());
        mParser.setNodeFactory((NodeFactory)factory);
        resources = new HashSet();
    }

    protected String makeLocalLink(String source, String link, String current) {
        int dotIndex;
        String ret;
        if ((link = this.cleanString(link)).equals(source = this.cleanString(source)) || !source.endsWith("/") && link.equals(source + "/")) {
            if (source.endsWith("/")) {
                ret = "index.html";
            } else {
                int k = source.lastIndexOf(47);
                int z = source.indexOf(47);
                ret = z == k - 1 ? "index.html" : source.substring(k);
            }
        } else {
            ret = link.startsWith(source) && link.length() > source.length() ? link.substring(source.length() + 1) : link;
        }
        if (null != current && link.startsWith(source) && current.length() > source.length()) {
            int j;
            current = current.substring(source.length() + 1);
            int i = 0;
            while (-1 != (j = current.indexOf(47, i))) {
                ret = "../" + ret;
                i = j + 1;
            }
        }
        if ((dotIndex = ret.indexOf(".")) == -1) {
            ret = ret + ".html";
        }
        return ret;
    }

    protected boolean isToBeCaptured(String link) {
        return link.toLowerCase().startsWith(mSource.toLowerCase()) && -1 == link.indexOf("?") && -1 == link.indexOf("#");
    }

    public static void main(String[] args) {
        String url = "http://localhost:4277/jlibrary/index.html";
        HTMLRipper ripper = new HTMLRipper();
        try {
            ripper.crawlFileWithResources(new File("/temp"), url);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private String cleanString(String source) {
        source = StringUtils.replaceChars((String)source, (char)'?', (char)'_');
        source = StringUtils.replaceChars((String)source, (char)'&', (char)'_');
        return source;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        resourcesDirectory = "";
    }

    class LocalMetaLinkTag
    extends TagNode {
        private static final long serialVersionUID = 1L;
        private final String[] mIds = new String[]{"LINK"};

        public String[] getIds() {
            return this.mIds;
        }

        public String getRel() {
            return this.getAttribute("REL");
        }

        public String getHref() {
            return this.getAttribute("HREF");
        }

        public String getType() {
            return this.getAttribute("TYPE");
        }

        public String getMedia() {
            return this.getAttribute("MEDIA");
        }

        public String getMetaLinkTagName() {
            return this.getAttribute("NAME");
        }

        public void setRel(String rel) {
            Attribute att = this.getAttributeEx("REL");
            if (null != att) {
                att.setValue(rel);
            } else {
                this.getAttributesEx().add(new Attribute("REL", rel));
            }
        }

        public void setHref(String href) {
            Attribute att = this.getAttributeEx("HREF");
            if (null != att) {
                att.setValue(href);
            } else {
                this.getAttributesEx().add(new Attribute("HREF", href));
            }
        }

        public void setType(String type) {
            Attribute att = this.getAttributeEx("TYPE");
            if (null != att) {
                att.setValue(type);
            } else {
                this.getAttributesEx().add(new Attribute("TYPE", type));
            }
        }

        public void setMedia(String media) {
            Attribute att = this.getAttributeEx("MEDIA");
            if (null != att) {
                att.setValue(media);
            } else {
                this.getAttributesEx().add(new Attribute("MEDIA", media));
            }
        }

        public void setMetaTagName(String metaTagName) {
            Attribute name = this.getAttributeEx("NAME");
            if (null != name) {
                name.setValue(metaTagName);
            } else {
                this.getAttributesEx().add(new Attribute("NAME", metaTagName));
            }
        }

        public void doSemanticAction() throws ParserException {
            String type = this.getType();
            if (type.equals("text/css")) {
                String url = this.getPage().getAbsoluteURL(this.getHref());
                resources.add(url);
                int i = url.lastIndexOf(47);
                String hrefName = url.substring(i);
                this.setHref(resourcesDirectory + hrefName);
            }
        }
    }

    class LocalBaseHrefTag
    extends BaseHrefTag {
        private static final long serialVersionUID = 1L;

        LocalBaseHrefTag() {
        }

        public String toHtml() {
            return "";
        }
    }

    class LocalImageTag
    extends ImageTag {
        private static final long serialVersionUID = 1L;

        LocalImageTag() {
        }

        public void doSemanticAction() throws ParserException {
            String image = this.getImageURL();
            resources.add(image);
            int i = image.lastIndexOf(47);
            String imageName = image.substring(i);
            this.setImageURL(resourcesDirectory + imageName);
        }
    }

    class LocalFrameTag
    extends FrameTag {
        private static final long serialVersionUID = 1L;

        LocalFrameTag() {
        }

        public void doSemanticAction() throws ParserException {
            String link = this.getFrameLocation();
            if (HTMLRipper.this.isToBeCaptured(link)) {
                // empty if block
            }
        }
    }

    class LocalLinkTag
    extends LinkTag {
        private static final long serialVersionUID = 1L;

        LocalLinkTag() {
        }

        public void doSemanticAction() throws ParserException {
            String link = this.getLink();
            if (HTMLRipper.this.isToBeCaptured(link)) {
                // empty if block
            }
        }
    }
}

