/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.search.extraction.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler
implements ErrorHandler {
    private XMLReader xmlReader;
    private StringBuffer buffer;

    public XMLParser(XMLReader xmlReader) {
        try {
            this.xmlReader = xmlReader;
            this.xmlReader.setContentHandler(this);
            this.xmlReader.setErrorHandler(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startDocument() throws SAXException {
        this.buffer = new StringBuffer();
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(ch, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
    }

    public void warning(SAXParseException spe) throws SAXException {
    }

    public void error(SAXParseException spe) throws SAXException {
    }

    public void fatalError(SAXParseException spe) throws SAXException {
    }

    public void parse(File f) throws FileNotFoundException, IOException, SAXException {
        this.xmlReader.parse(new InputSource(new FileInputStream(f)));
    }

    public void parse(byte[] content) throws FileNotFoundException, IOException, SAXException {
        this.xmlReader.parse(new InputSource(new ByteArrayInputStream(content)));
    }

    public String getContents() {
        Object[] words = StringUtils.split((String)this.buffer.toString());
        return StringUtils.join((Object[])words, (String)" ");
    }
}

