/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.search.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.jlibrary.core.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnglishAnalyzer
extends Analyzer {
    static Logger logger = LoggerFactory.getLogger((Class)(class$org$jlibrary$core$search$lucene$EnglishAnalyzer == null ? (class$org$jlibrary$core$search$lucene$EnglishAnalyzer = EnglishAnalyzer.class$("org.jlibrary.core.search.lucene.EnglishAnalyzer")) : class$org$jlibrary$core$search$lucene$EnglishAnalyzer));
    private static StandardAnalyzer analyzer;
    private static String[] ENGLISH_STOP_WORDS;
    static /* synthetic */ Class class$org$jlibrary$core$search$lucene$EnglishAnalyzer;

    public EnglishAnalyzer() {
        EnglishAnalyzer.initStopWords();
        analyzer = new StandardAnalyzer(ENGLISH_STOP_WORDS);
    }

    public EnglishAnalyzer(String[] stopWords) {
        EnglishAnalyzer.initStopWords();
        analyzer = new StandardAnalyzer(stopWords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initStopWords() {
        if (ENGLISH_STOP_WORDS == null) {
            InputStream is = null;
            try {
                is = ResourceLoader.getResourceAsStream((String)"org/jlibrary/core/search/lucene/indexers/english.stop");
                if (is != null) {
                    StringBuilder words = new StringBuilder(IOUtils.toString((InputStream)is, (String)"iso_8859_1"));
                    ENGLISH_STOP_WORDS = words.toString().split("\r\n");
                } else {
                    ENGLISH_STOP_WORDS = new String[0];
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public static final String[] getStopWords() {
        if (ENGLISH_STOP_WORDS == null) {
            EnglishAnalyzer.initStopWords();
        }
        return ENGLISH_STOP_WORDS;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return analyzer.tokenStream(fieldName, reader);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

