/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.search.lucene;

import java.util.HashMap;
import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.jlibrary.core.i18n.LocaleService;
import org.jlibrary.core.search.lucene.EnglishAnalyzer;
import org.jlibrary.core.search.lucene.SpanishAnalyzer;

public class JLibraryIndexer {
    private HashMap analyzers;
    Analyzer defaultAnalyzer = new StopAnalyzer();

    public Analyzer getAnalyzer(Locale locale) {
        Analyzer analyzer;
        if (this.analyzers == null) {
            this.initStopWords();
        }
        if ((analyzer = (Analyzer)this.analyzers.get(locale.getLanguage())) == null) {
            return this.defaultAnalyzer;
        }
        return analyzer;
    }

    private void initStopWords() {
        this.analyzers = new HashMap();
        this.analyzers.put(LocaleService.SPANISH_LOCALE.getLanguage(), new SpanishAnalyzer());
        this.analyzers.put(LocaleService.ENGLISH_LOCALE.getLanguage(), new EnglishAnalyzer());
        this.analyzers.put(LocaleService.FRENCH_LOCALE.getLanguage(), new StandardAnalyzer());
        this.analyzers.put(LocaleService.ITALIAN_LOCALE.getLanguage(), new StandardAnalyzer());
        this.analyzers.put(LocaleService.DUTCH_LOCALE.getLanguage(), new StandardAnalyzer());
        this.analyzers.put(LocaleService.FINNISH_LOCALE.getLanguage(), new StandardAnalyzer());
        this.analyzers.put(LocaleService.NORWEGIAN_LOCALE.getLanguage(), new StandardAnalyzer());
        this.analyzers.put(LocaleService.PORTUGUESE_LOCALE.getLanguage(), new StandardAnalyzer());
        this.analyzers.put(LocaleService.RUSSIAN_LOCALE.getLanguage(), new StandardAnalyzer());
        this.analyzers.put(LocaleService.SWEDISH_LOCALE.getLanguage(), new StandardAnalyzer());
    }
}

