/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.search.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.jlibrary.core.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanishAnalyzer
extends Analyzer {
    static Logger logger = LoggerFactory.getLogger((Class)(class$org$jlibrary$core$search$lucene$SpanishAnalyzer == null ? (class$org$jlibrary$core$search$lucene$SpanishAnalyzer = SpanishAnalyzer.class$("org.jlibrary.core.search.lucene.SpanishAnalyzer")) : class$org$jlibrary$core$search$lucene$SpanishAnalyzer));
    private static StandardAnalyzer analyzer;
    private static String[] SPANISH_STOP_WORDS;
    static /* synthetic */ Class class$org$jlibrary$core$search$lucene$SpanishAnalyzer;

    public SpanishAnalyzer() {
        SpanishAnalyzer.initStopWords();
        analyzer = new StandardAnalyzer(SPANISH_STOP_WORDS);
    }

    public SpanishAnalyzer(String[] stopWords) {
        SpanishAnalyzer.initStopWords();
        analyzer = new StandardAnalyzer(stopWords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initStopWords() {
        if (SPANISH_STOP_WORDS == null) {
            InputStream is = null;
            try {
                is = ResourceLoader.getResourceAsStream((String)"org/jlibrary/core/search/lucene/indexers/spanish.stop");
                if (is != null) {
                    StringBuilder words = new StringBuilder(IOUtils.toString((InputStream)is, (String)"iso_8859_1"));
                    SPANISH_STOP_WORDS = words.toString().split("\r\n");
                } else {
                    SPANISH_STOP_WORDS = new String[0];
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public static final String[] getStopWords() {
        if (SPANISH_STOP_WORDS == null) {
            SpanishAnalyzer.initStopWords();
        }
        return SPANISH_STOP_WORDS;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return analyzer.tokenStream(fieldName, reader);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

