/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.servlet;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AxisServlet;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class JLibraryStartupAxisServlet
extends AxisServlet {
    private static final long serialVersionUID = 2958184797904116139L;
    static Logger logger = LoggerFactory.getLogger(JLibraryStartupAxisServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.deployWebServices(config.getServletContext());
    }

    public String getServletInfo() {
        return "jLibrary Startup servlet";
    }

    public void deployWebServices(ServletContext context) {
        this.processWS("wsdd/undeploy-repository.wsdd");
        this.processWS("wsdd/undeploy-security.wsdd");
        this.processWS("wsdd/undeploy-search.wsdd");
        this.processWS("wsdd/deploy-repository.wsdd");
        this.processWS("wsdd/deploy-security.wsdd");
        this.processWS("wsdd/deploy-search.wsdd");
    }

    private void processWS(String url) {
        logger.info("Processing {" + url + "}");
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(url);
            byte[] array = IOUtils.toByteArray((InputStream)is);
            ByteArrayInputStream bais = new ByteArrayInputStream(array);
            AxisServer engine = this.getEngine();
            Document doc = XMLUtils.newDocument((InputStream)bais);
            WSDDDocument wsddDoc = new WSDDDocument(doc.getDocumentElement());
            EngineConfiguration config = engine.getConfig();
            if (config instanceof WSDDEngineConfiguration) {
                WSDDDeployment deployment = ((WSDDEngineConfiguration)config).getDeployment();
                wsddDoc.deploy(deployment);
            }
            engine.refreshGlobalOptions();
            engine.saveConfiguration();
            bais.close();
            is.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
        super.destroy();
    }
}

