/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.axis.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.client.Transport;
import org.apache.axis.configuration.XMLStringProvider;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.transport.http.HTTPTransport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.ByteArrayDataSource;
import org.jlibrary.core.entities.Author;
import org.jlibrary.core.entities.Bookmark;
import org.jlibrary.core.entities.Category;
import org.jlibrary.core.entities.Directory;
import org.jlibrary.core.entities.Document;
import org.jlibrary.core.entities.Favorite;
import org.jlibrary.core.entities.Lock;
import org.jlibrary.core.entities.Node;
import org.jlibrary.core.entities.Repository;
import org.jlibrary.core.entities.ResourceNode;
import org.jlibrary.core.entities.Ticket;
import org.jlibrary.core.entities.User;
import org.jlibrary.core.locking.ResourceLockedException;
import org.jlibrary.core.profiles.AxisServerProfile;
import org.jlibrary.core.properties.AuthorProperties;
import org.jlibrary.core.properties.CategoryProperties;
import org.jlibrary.core.properties.CustomPropertyDefinition;
import org.jlibrary.core.properties.DirectoryProperties;
import org.jlibrary.core.properties.DocumentProperties;
import org.jlibrary.core.properties.InvalidPropertyTypeException;
import org.jlibrary.core.properties.PropertyNotFoundException;
import org.jlibrary.core.properties.RepositoryProperties;
import org.jlibrary.core.properties.ResourceNodeProperties;
import org.jlibrary.core.repository.RepositoryService;
import org.jlibrary.core.repository.exception.AuthorAlreadyExistsException;
import org.jlibrary.core.repository.exception.AuthorNotFoundException;
import org.jlibrary.core.repository.exception.CategoryAlreadyExistsException;
import org.jlibrary.core.repository.exception.CategoryNotFoundException;
import org.jlibrary.core.repository.exception.NodeNotFoundException;
import org.jlibrary.core.repository.exception.RecentlyRemovedRepositoryException;
import org.jlibrary.core.repository.exception.RepositoryAlreadyExistsException;
import org.jlibrary.core.repository.exception.RepositoryException;
import org.jlibrary.core.repository.exception.RepositoryNotFoundException;
import org.jlibrary.core.repository.exception.UnknownMethodException;
import org.jlibrary.core.security.SecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxisRepositoryDelegate
implements RepositoryService {
    static Logger logger = LoggerFactory.getLogger((Class)(class$org$jlibrary$core$axis$client$AxisSecurityDelegate == null ? (class$org$jlibrary$core$axis$client$AxisSecurityDelegate = AxisRepositoryDelegate.class$("org.jlibrary.core.axis.client.AxisSecurityDelegate")) : class$org$jlibrary$core$axis$client$AxisSecurityDelegate));
    private String endpoint;
    private Service axisService = new Service((EngineConfiguration)new XMLStringProvider("<deployment xmlns=\"http://xml.apache.org/axis/wsdd/\" xmlns:java=\"http://xml.apache.org/axis/wsdd/providers/java\">\n <transport name=\"local\" pivot=\"java:org.apache.axis.transport.local.LocalSender\"/>\n <transport name=\"java\" pivot=\"java:org.apache.axis.transport.http.JavaSender\"/>\n <transport name=\"http\" pivot=\"java:org.apache.axis.transport.http.CommonsHTTPSender\"/>\n</deployment>"));
    private Call call;
    static /* synthetic */ Class class$org$jlibrary$core$axis$client$AxisSecurityDelegate;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Repository;
    static /* synthetic */ Class class$org$jlibrary$core$entities$User;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Group;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Member;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Directory;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Document;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Node;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Favorite;
    static /* synthetic */ Class class$org$jlibrary$core$entities$DocumentMetaData;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Category;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Rol;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Bookmark;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Author;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Note;
    static /* synthetic */ Class class$org$jlibrary$core$properties$DocumentProperties;
    static /* synthetic */ Class class$org$jlibrary$core$properties$PropertyDef;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Credentials;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Ticket;
    static /* synthetic */ Class class$org$jlibrary$core$entities$RepositoryInfo;
    static /* synthetic */ Class class$org$jlibrary$core$entities$CategoryNode;
    static /* synthetic */ Class class$org$jlibrary$core$entities$DocumentVersion;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Relation;
    static /* synthetic */ Class class$org$jlibrary$core$properties$CategoryProperties;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Lock;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Restriction;
    static /* synthetic */ Class class$org$jlibrary$core$entities$ResourceNode;
    static /* synthetic */ Class class$org$jlibrary$core$properties$ResourceNodeProperties;
    static /* synthetic */ Class class$org$jlibrary$core$properties$DirectoryProperties;
    static /* synthetic */ Class class$org$jlibrary$core$properties$RepositoryProperties;
    static /* synthetic */ Class class$org$jlibrary$core$entities$RepositoryConfig;
    static /* synthetic */ Class class$org$jlibrary$core$properties$AuthorProperties;
    static /* synthetic */ Class class$org$jlibrary$core$properties$GenericProperties;
    static /* synthetic */ Class class$org$jlibrary$core$properties$CustomPropertyDefinition;

    public AxisRepositoryDelegate(AxisServerProfile profile) {
        try {
            String location = profile.getLocation();
            location = StringUtils.replace((String)location, (String)"jlibrary://", (String)"http://");
            if (!location.endsWith("/")) {
                location = location + "/";
            }
            this.endpoint = location + "services/AxisRepositoryService";
            this.call = (Call)this.axisService.createCall();
            this.call.setTransport((Transport)new HTTPTransport());
            this.call.setMaintainSession(true);
        }
        catch (ServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.registerSerializers(this.call);
    }

    public Repository createRepository(Ticket ticket, String name, String description, User creator) throws RepositoryAlreadyExistsException, RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("createRepository");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("name", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("description", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("creator", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Repository r = (Repository)this.call.invoke(new Object[]{ticket, name, description, creator});
            return r;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("RepositoryAlreadyExistsException") != -1) {
                throw new RepositoryAlreadyExistsException();
            }
            if (fault.getFaultString().indexOf("RecentlyRemovedRepositoryException") != -1) {
                throw new RecentlyRemovedRepositoryException();
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Directory createDirectory(Ticket ticket, String name, String description, String parentId) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("createDirectory");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("name", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("description", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("parent", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Directory dir = (Directory)this.call.invoke(new Object[]{ticket, name, description, parentId});
            return dir;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Directory createDirectory(Ticket ticket, DirectoryProperties properties) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("createDirectory");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("properties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Directory dir = (Directory)this.call.invoke(new Object[]{ticket, properties});
            return dir;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public void removeDirectory(Ticket ticket, String directoryId) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("removeDirectory");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("directoryId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, directoryId});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public List findAllRepositoriesInfo(Ticket ticket) throws RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findAllRepositoriesInfo");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Object[] o = (Object[])this.call.invoke(new Object[]{ticket});
            ArrayList list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])o);
            return list;
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Repository findRepository(String id, Ticket ticket) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findRepository");
            this.call.addParameter("id", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Repository repository = (Repository)this.call.invoke(new Object[]{id, ticket});
            return repository;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("RepositoryNotFoundException") != -1) {
                throw new RepositoryNotFoundException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Document findDocument(Ticket ticket, String id) throws RepositoryException, NodeNotFoundException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findDocument");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("id", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Document document = (Document)this.call.invoke(new Object[]{ticket, id});
            return document;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("NodeNotFoundException") != -1) {
                throw new NodeNotFoundException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Node findNode(Ticket ticket, String id) throws RepositoryException, NodeNotFoundException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findNode");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("id", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Node node = (Node)this.call.invoke(new Object[]{ticket, id});
            return node;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("NodeNotFoundException") != -1) {
                throw new NodeNotFoundException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Directory findDirectory(Ticket ticket, String id) throws RepositoryException, NodeNotFoundException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findDirectory");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("id", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Directory directory = (Directory)this.call.invoke(new Object[]{ticket, id});
            return directory;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("NodeNotFoundException") != -1) {
                throw new NodeNotFoundException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public void deleteRepository(Ticket ticket) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("deleteRepository");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Directory copyDirectory(Ticket ticket, String sourceId, String destinationId, String destinationRepository) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("copyDirectory");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("sourceId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("destinationId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("destinationRepository", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Directory directory = (Directory)this.call.invoke(new Object[]{ticket, sourceId, destinationId, destinationRepository});
            return directory;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Document copyDocument(Ticket ticket, String sourceId, String destinationId, String destinationRepository) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("copyDocument");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("sourceId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("destinationId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Document document = (Document)this.call.invoke(new Object[]{ticket, sourceId, destinationId, destinationRepository});
            return document;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Directory moveDirectory(Ticket ticket, String sourceId, String destinationId, String destinationRepository) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("moveDirectory");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("sourceId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("destinationId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("destinationRepository", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Directory directory = (Directory)this.call.invoke(new Object[]{ticket, sourceId, destinationId, destinationRepository});
            return directory;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Document moveDocument(Ticket ticket, String documentId, String directoryId, String destinationRepository) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("moveDocument");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("documentId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("directoryId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("destinationRepository", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (Document)this.call.invoke(new Object[]{ticket, documentId, directoryId, destinationRepository});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public byte[] loadDocumentContent(String docId, Ticket ticket) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("loadDocumentContent");
            this.call.addParameter("docId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.SOAP_BASE64BINARY);
            this.call.invoke(new Object[]{docId, ticket});
            return this.extractAttachment();
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Document createDocument(Ticket ticket, DocumentProperties docProperties) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("createDocument");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("docProperties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            byte[] content = (byte[])docProperties.getProperty((Object)"document.content").getValue();
            if (content != null) {
                docProperties.setProperty((Object)"document.content", null);
                DataHandler handler = new DataHandler((DataSource)new ByteArrayDataSource(content, "application/octet-stream"));
                this.call.addAttachmentPart((Object)handler);
            }
            Document document = (Document)this.call.invoke(new Object[]{ticket, docProperties});
            return document;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Document createDocument(Ticket ticket, DocumentProperties docProperties, InputStream contentStream) throws RepositoryException, SecurityException {
        byte[] content;
        try {
            content = IOUtils.toByteArray((InputStream)contentStream);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        try {
            docProperties.setProperty((Object)"document.content", (Object)content);
        }
        catch (PropertyNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        catch (InvalidPropertyTypeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        return this.createDocument(ticket, docProperties);
    }

    public List createDocuments(Ticket ticket, List properties) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("createDocuments");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("properties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Iterator it = properties.iterator();
            while (it.hasNext()) {
                DocumentProperties props = (DocumentProperties)it.next();
                byte[] content = (byte[])props.getProperty((Object)"document.content").getValue();
                if (content == null) continue;
                props.setProperty((Object)"document.content", null);
                DataHandler handler = new DataHandler((DataSource)new ByteArrayDataSource(content, "application/octet-stream"));
                this.call.addAttachmentPart((Object)handler);
            }
            Object[] o = (Object[])this.call.invoke(new Object[]{ticket, properties});
            ArrayList list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])o);
            return list;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public void removeDocument(Ticket ticket, String docId) throws RepositoryException, SecurityException, ResourceLockedException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("removeDocument");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("docId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, docId});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("ResourceLockedException") != -1) {
                Lock lock = this.lookForLock(ticket, docId);
                throw new ResourceLockedException(lock);
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Document updateDocument(Ticket ticket, DocumentProperties docProperties) throws RepositoryException, SecurityException, ResourceLockedException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("updateDocument");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("docProperties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            byte[] content = (byte[])docProperties.getProperty((Object)"document.content").getValue();
            if (content != null) {
                docProperties.setProperty((Object)"document.content", null);
                DataHandler handler = new DataHandler((DataSource)new ByteArrayDataSource(content, "application/octet-stream"));
                this.call.addAttachmentPart((Object)handler);
            }
            return (Document)this.call.invoke(new Object[]{ticket, docProperties});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("ResourceLockedException") != -1) {
                String docId = docProperties.getProperty((Object)"document.id").getValue().toString();
                Lock lock = this.lookForLock(ticket, docId);
                throw new ResourceLockedException(lock);
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Document updateDocument(Ticket ticket, DocumentProperties docProperties, InputStream contentStream) throws RepositoryException, SecurityException, ResourceLockedException {
        byte[] content;
        try {
            content = IOUtils.toByteArray((InputStream)contentStream);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        try {
            docProperties.setProperty((Object)"document.content", (Object)content);
        }
        catch (PropertyNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        catch (InvalidPropertyTypeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        return this.updateDocument(ticket, docProperties);
    }

    public Directory updateDirectory(Ticket ticket, DirectoryProperties directoryProperties) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("updateDirectory");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("directoryProperties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (Directory)this.call.invoke(new Object[]{ticket, directoryProperties});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Repository updateRepository(Ticket ticket, RepositoryProperties repositoryProperties) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("updateRepository");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("RepositoryProperties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (Repository)this.call.invoke(new Object[]{ticket, repositoryProperties});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public void renameNode(Ticket ticket, String nodeId, String name) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("renameNode");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("nodeId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("name", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, nodeId, name});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public List findAllAuthors(Ticket ticket) throws RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findAllAuthors");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Object[] o = (Object[])this.call.invoke(new Object[]{ticket});
            ArrayList list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])o);
            return list;
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Author findAuthorByName(Ticket ticket, String name) throws AuthorNotFoundException, RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findAuthorByName");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("name", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Author author = (Author)this.call.invoke(new Object[]{ticket, name});
            return author;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("AuthorNotFoundException") != -1) {
                throw new AuthorNotFoundException();
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Author findAuthorById(Ticket ticket, String id) throws AuthorNotFoundException, RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findAuthorById");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("id", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Author author = (Author)this.call.invoke(new Object[]{ticket, id});
            return author;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("AuthorNotFoundException") != -1) {
                throw new AuthorNotFoundException();
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public List findAllCategories(Ticket ticket) throws RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findAllCategories");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Object[] o = (Object[])this.call.invoke(new Object[]{ticket});
            ArrayList list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])o);
            return list;
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Author createAuthor(Ticket ticket, AuthorProperties properties) throws RepositoryException, SecurityException, AuthorAlreadyExistsException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("createAuthor");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("properties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Author author = (Author)this.call.invoke(new Object[]{ticket, properties});
            return author;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("AuthorAlreadyExistsException") != -1) {
                throw new AuthorAlreadyExistsException();
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public void updateAuthor(Ticket ticket, String authorId, AuthorProperties properties) throws RepositoryException, SecurityException, AuthorNotFoundException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("updateAuthor");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("authorId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("properties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, authorId, properties});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("AuthorNotFoundException") != -1) {
                throw new AuthorNotFoundException();
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public void deleteAuthor(Ticket ticket, String authorId) throws RepositoryException, SecurityException, AuthorNotFoundException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("deleteAuthor");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("authorId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, authorId});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("AuthorNotFoundException") != -1) {
                throw new AuthorNotFoundException();
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Category createCategory(Ticket ticket, CategoryProperties categoryProperties) throws CategoryAlreadyExistsException, RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("createCategory");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("categoryProperties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Category category = (Category)this.call.invoke(new Object[]{ticket, categoryProperties});
            return category;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("CategoryAlreadyExistsException") != -1) {
                throw new CategoryAlreadyExistsException();
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Category findCategoryById(Ticket ticket, String id) throws CategoryNotFoundException, RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findCategoryById");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("categoryId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (Category)this.call.invoke(new Object[]{ticket, id});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("CategoryNotFoundException") != -1) {
                throw new CategoryNotFoundException();
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Category findCategoryByName(Ticket ticket, String name) throws CategoryNotFoundException, RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findCategoryByName");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("name", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (Category)this.call.invoke(new Object[]{ticket, name});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("CategoryNotFoundException") != -1) {
                throw new CategoryNotFoundException();
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public List findCategoriesForNode(Ticket ticket, String nodeId) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findCategoriesForNode");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("nodeId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Object[] o = (Object[])this.call.invoke(new Object[]{ticket, nodeId});
            ArrayList list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])o);
            return list;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public List findNodesForCategory(Ticket ticket, String categoryId) throws CategoryNotFoundException, RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findNodesForCategory");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("categoryId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Object[] o = (Object[])this.call.invoke(new Object[]{ticket, categoryId});
            ArrayList list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])o);
            return list;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("CategoryNotFoundException") != -1) {
                throw new CategoryNotFoundException();
            }
            throw new RepositoryException((Throwable)e);
        }
    }

    public void deleteCategory(Ticket ticket, String categoryId) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("deleteCategory");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("categoryId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, categoryId});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Category updateCategory(Ticket ticket, String categoryId, CategoryProperties categoryProperties) throws CategoryNotFoundException, RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("updateCategory");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("categoryId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("categoryProperties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (Category)this.call.invoke(new Object[]{ticket, categoryId, categoryProperties});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("CategoryNotFoundException") != -1) {
                throw new CategoryNotFoundException();
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Favorite createFavorite(Ticket ticket, Favorite favorite) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("createFavorite");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("favorite", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (Favorite)this.call.invoke(new Object[]{ticket, favorite});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public void deleteFavorite(Ticket ticket, String favoriteId) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("deleteFavorite");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("favoriteId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, favoriteId});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Bookmark createBookmark(Ticket ticket, Bookmark bookmark) throws RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("createBookmark");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("bookmark", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (Bookmark)this.call.invoke(new Object[]{ticket, bookmark});
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void removeBookmark(Ticket ticket, String bookmarkId) throws RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("removeBookmark");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("bookmarkId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, bookmarkId});
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Bookmark updateBookmark(Ticket ticket, Bookmark bookmark) throws RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("updateBookmark");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("bookmark", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (Bookmark)this.call.invoke(new Object[]{ticket, bookmark});
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public byte[] exportRepository(Ticket ticket) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("exportRepository");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.SOAP_BASE64BINARY);
            this.call.invoke(new Object[]{ticket});
            return this.extractAttachment();
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("RepositoryNotFoundException") != -1) {
                throw new RepositoryNotFoundException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public void importRepository(Ticket ticket, byte[] content, String name) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("importRepository");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("content", Constants.SOAP_BASE64BINARY, ParameterMode.IN);
            this.call.addParameter("name", Constants.XSD_STRING, ParameterMode.IN);
            DataHandler handler = new DataHandler((DataSource)new ByteArrayDataSource(content, "application/octet-stream"));
            this.call.addAttachmentPart((Object)handler);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, new byte[0], name});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("RepositoryAlreadyExistsException") != -1) {
                throw new RepositoryAlreadyExistsException();
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public byte[] loadVersionContent(Ticket ticket, String versionId) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("loadVersionContent");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("versionId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.SOAP_BASE64BINARY);
            this.call.invoke(new Object[]{ticket, versionId});
            return this.extractAttachment();
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Lock lockDocument(Ticket ticket, String docId) throws RepositoryException, SecurityException, ResourceLockedException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("lockDocument");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("docId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (Lock)this.call.invoke(new Object[]{ticket, docId});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("ResourceLockedException") != -1) {
                Lock lock = this.lookForLock(ticket, docId);
                throw new ResourceLockedException(lock);
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public void unlockDocument(Ticket ticket, String docId) throws RepositoryException, SecurityException, ResourceLockedException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("unlockDocument");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("docId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, docId});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("ResourceLockedException") != -1) {
                Lock lock = this.lookForLock(ticket, docId);
                throw new ResourceLockedException(lock);
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public List findAllLocks(Ticket ticket) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findAllLocks");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Object[] o = (Object[])this.call.invoke(new Object[]{ticket});
            ArrayList list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])o);
            return list;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public ResourceNode createResource(Ticket ticket, ResourceNodeProperties properties) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("createResource");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("properties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            byte[] content = (byte[])properties.getProperty((Object)"resource.content").getValue();
            if (content != null) {
                properties.setProperty((Object)"resource.content", null);
                DataHandler handler = new DataHandler((DataSource)new ByteArrayDataSource(content, "application/octet-stream"));
                this.call.addAttachmentPart((Object)handler);
            }
            return (ResourceNode)this.call.invoke(new Object[]{ticket, properties});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public void addResourceToDocument(Ticket ticket, String resourceId, String documentId) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("addResourceToDocument");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("resource", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("document", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, resourceId, documentId});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public List findNodesForResource(Ticket ticket, String resourceId) throws RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findNodesForResource");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("resourceId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Object[] o = (Object[])this.call.invoke(new Object[]{ticket, resourceId});
            ArrayList list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])o);
            return list;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public byte[] loadResourceNodeContent(Ticket ticket, String resourceId) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("loadResourceNodeContent");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("resourceId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.SOAP_BASE64BINARY);
            this.call.invoke(new Object[]{ticket, resourceId});
            return this.extractAttachment();
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public ResourceNode updateResourceNode(Ticket ticket, ResourceNodeProperties properties) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("updateResourceNode");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("properties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            byte[] content = (byte[])properties.getProperty((Object)"resource.content").getValue();
            if (content != null) {
                properties.setProperty((Object)"resource.content", null);
                DataHandler handler = new DataHandler((DataSource)new ByteArrayDataSource(content, "application/octet-stream"));
                this.call.addAttachmentPart((Object)handler);
            }
            return (ResourceNode)this.call.invoke(new Object[]{ticket, properties});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public void removeResourceNode(Ticket ticket, String resourceId) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("removeResourceNode");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("resourceId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, resourceId});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public void removeResourceNode(Ticket ticket, String resourceId, String docId) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("removeResourceNode");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("resourceId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("docId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, resourceId, docId});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public ResourceNode copyResource(Ticket ticket, String resourceId, String directoryId, String destinationRepository) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("copyResource");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("resourceId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("directoryId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("destinationRepository", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (ResourceNode)this.call.invoke(new Object[]{ticket, resourceId, directoryId, destinationRepository});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public ResourceNode moveResource(Ticket ticket, String resourceId, String directoryId, String destinationRepository) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("moveResource");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("resourceId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("directoryId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("destinationRepository", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (ResourceNode)this.call.invoke(new Object[]{ticket, resourceId, directoryId, destinationRepository});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public Node copyNode(Ticket ticket, String sourceId, String directoryId, String destinationRepository) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("copyNode");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("sourceId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("directoryId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("destinationRepository", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (Node)this.call.invoke(new Object[]{ticket, sourceId, directoryId, destinationRepository});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public List getVersions(Ticket ticket, String documentId) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("getVersions");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("documentId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Object[] o = (Object[])this.call.invoke(new Object[]{ticket, documentId});
            ArrayList list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])o);
            return list;
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Collection findDocumentsByName(Ticket ticket, String name) throws RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findDocumentsByName");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("name", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Object[] o = (Object[])this.call.invoke(new Object[]{ticket, name});
            ArrayList list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])o);
            return list;
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Node moveNode(Ticket ticket, String sourceId, String directoryId, String destinationRepository) throws RepositoryException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("moveNode");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("sourceId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("directoryId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("destinationRepository", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (Node)this.call.invoke(new Object[]{ticket, sourceId, directoryId, destinationRepository});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public void saveSession(Ticket ticket) throws RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("saveSession");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            throw new RepositoryException(fault.getFaultString());
        }
    }

    private byte[] extractAttachment() throws IOException, SOAPException {
        Message response = this.call.getMessageContext().getResponseMessage();
        Iterator it = response.getAttachments();
        AttachmentPart attachment = (AttachmentPart)it.next();
        InputStream is = attachment.getDataHandler().getInputStream();
        byte[] content = IOUtils.toByteArray((InputStream)is);
        is.close();
        return content;
    }

    public Collection findNodeChildren(Ticket ticket, String id) throws RepositoryException, NodeNotFoundException, SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("findNodeChildren");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("id", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Object[] o = (Object[])this.call.invoke(new Object[]{ticket, id});
            HashSet set = new HashSet();
            CollectionUtils.addAll(set, (Object[])o);
            return set;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("NodeNotFoundException") != -1) {
                throw new NodeNotFoundException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    private void registerSerializers(Call call) {
        QName qn = new QName("urn:BeanService", "Repository");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Repository == null ? (class$org$jlibrary$core$entities$Repository = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Repository")) : class$org$jlibrary$core$entities$Repository, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Repository == null ? (class$org$jlibrary$core$entities$Repository = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Repository")) : class$org$jlibrary$core$entities$Repository, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Repository == null ? (class$org$jlibrary$core$entities$Repository = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Repository")) : class$org$jlibrary$core$entities$Repository, qn));
        qn = new QName("urn:BeanService", "User");
        call.registerTypeMapping(class$org$jlibrary$core$entities$User == null ? (class$org$jlibrary$core$entities$User = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.User")) : class$org$jlibrary$core$entities$User, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$User == null ? (class$org$jlibrary$core$entities$User = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.User")) : class$org$jlibrary$core$entities$User, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$User == null ? (class$org$jlibrary$core$entities$User = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.User")) : class$org$jlibrary$core$entities$User, qn));
        qn = new QName("urn:BeanService", "Group");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Group == null ? (class$org$jlibrary$core$entities$Group = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Group")) : class$org$jlibrary$core$entities$Group, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Group == null ? (class$org$jlibrary$core$entities$Group = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Group")) : class$org$jlibrary$core$entities$Group, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Group == null ? (class$org$jlibrary$core$entities$Group = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Group")) : class$org$jlibrary$core$entities$Group, qn));
        qn = new QName("urn:BeanService", "Member");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Member == null ? (class$org$jlibrary$core$entities$Member = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Member")) : class$org$jlibrary$core$entities$Member, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Member == null ? (class$org$jlibrary$core$entities$Member = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Member")) : class$org$jlibrary$core$entities$Member, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Member == null ? (class$org$jlibrary$core$entities$Member = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Member")) : class$org$jlibrary$core$entities$Member, qn));
        qn = new QName("urn:BeanService", "Directory");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Directory == null ? (class$org$jlibrary$core$entities$Directory = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Directory")) : class$org$jlibrary$core$entities$Directory, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Directory == null ? (class$org$jlibrary$core$entities$Directory = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Directory")) : class$org$jlibrary$core$entities$Directory, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Directory == null ? (class$org$jlibrary$core$entities$Directory = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Directory")) : class$org$jlibrary$core$entities$Directory, qn));
        qn = new QName("urn:BeanService", "Document");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Document == null ? (class$org$jlibrary$core$entities$Document = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Document")) : class$org$jlibrary$core$entities$Document, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Document == null ? (class$org$jlibrary$core$entities$Document = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Document")) : class$org$jlibrary$core$entities$Document, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Document == null ? (class$org$jlibrary$core$entities$Document = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Document")) : class$org$jlibrary$core$entities$Document, qn));
        qn = new QName("urn:BeanService", "Node");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Node == null ? (class$org$jlibrary$core$entities$Node = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Node")) : class$org$jlibrary$core$entities$Node, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Node == null ? (class$org$jlibrary$core$entities$Node = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Node")) : class$org$jlibrary$core$entities$Node, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Node == null ? (class$org$jlibrary$core$entities$Node = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Node")) : class$org$jlibrary$core$entities$Node, qn));
        qn = new QName("urn:BeanService", "Favorite");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Favorite == null ? (class$org$jlibrary$core$entities$Favorite = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Favorite")) : class$org$jlibrary$core$entities$Favorite, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Favorite == null ? (class$org$jlibrary$core$entities$Favorite = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Favorite")) : class$org$jlibrary$core$entities$Favorite, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Favorite == null ? (class$org$jlibrary$core$entities$Favorite = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Favorite")) : class$org$jlibrary$core$entities$Favorite, qn));
        qn = new QName("urn:BeanService", "DocumentMetaData");
        call.registerTypeMapping(class$org$jlibrary$core$entities$DocumentMetaData == null ? (class$org$jlibrary$core$entities$DocumentMetaData = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.DocumentMetaData")) : class$org$jlibrary$core$entities$DocumentMetaData, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$DocumentMetaData == null ? (class$org$jlibrary$core$entities$DocumentMetaData = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.DocumentMetaData")) : class$org$jlibrary$core$entities$DocumentMetaData, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$DocumentMetaData == null ? (class$org$jlibrary$core$entities$DocumentMetaData = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.DocumentMetaData")) : class$org$jlibrary$core$entities$DocumentMetaData, qn));
        qn = new QName("urn:BeanService", "Category");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Category == null ? (class$org$jlibrary$core$entities$Category = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Category")) : class$org$jlibrary$core$entities$Category, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Category == null ? (class$org$jlibrary$core$entities$Category = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Category")) : class$org$jlibrary$core$entities$Category, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Category == null ? (class$org$jlibrary$core$entities$Category = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Category")) : class$org$jlibrary$core$entities$Category, qn));
        qn = new QName("urn:BeanService", "Rol");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Rol == null ? (class$org$jlibrary$core$entities$Rol = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Rol")) : class$org$jlibrary$core$entities$Rol, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Rol == null ? (class$org$jlibrary$core$entities$Rol = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Rol")) : class$org$jlibrary$core$entities$Rol, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Rol == null ? (class$org$jlibrary$core$entities$Rol = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Rol")) : class$org$jlibrary$core$entities$Rol, qn));
        qn = new QName("urn:BeanService", "Category");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Category == null ? (class$org$jlibrary$core$entities$Category = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Category")) : class$org$jlibrary$core$entities$Category, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Category == null ? (class$org$jlibrary$core$entities$Category = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Category")) : class$org$jlibrary$core$entities$Category, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Category == null ? (class$org$jlibrary$core$entities$Category = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Category")) : class$org$jlibrary$core$entities$Category, qn));
        qn = new QName("urn:BeanService", "Bookmark");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Bookmark == null ? (class$org$jlibrary$core$entities$Bookmark = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Bookmark")) : class$org$jlibrary$core$entities$Bookmark, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Bookmark == null ? (class$org$jlibrary$core$entities$Bookmark = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Bookmark")) : class$org$jlibrary$core$entities$Bookmark, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Bookmark == null ? (class$org$jlibrary$core$entities$Bookmark = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Bookmark")) : class$org$jlibrary$core$entities$Bookmark, qn));
        qn = new QName("urn:BeanService", "Author");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Author == null ? (class$org$jlibrary$core$entities$Author = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Author")) : class$org$jlibrary$core$entities$Author, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Author == null ? (class$org$jlibrary$core$entities$Author = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Author")) : class$org$jlibrary$core$entities$Author, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Author == null ? (class$org$jlibrary$core$entities$Author = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Author")) : class$org$jlibrary$core$entities$Author, qn));
        qn = new QName("urn:BeanService", "Note");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Note == null ? (class$org$jlibrary$core$entities$Note = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Note")) : class$org$jlibrary$core$entities$Note, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Note == null ? (class$org$jlibrary$core$entities$Note = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Note")) : class$org$jlibrary$core$entities$Note, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Note == null ? (class$org$jlibrary$core$entities$Note = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Note")) : class$org$jlibrary$core$entities$Note, qn));
        qn = new QName("urn:BeanService", "DocumentProperties");
        call.registerTypeMapping(class$org$jlibrary$core$properties$DocumentProperties == null ? (class$org$jlibrary$core$properties$DocumentProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.DocumentProperties")) : class$org$jlibrary$core$properties$DocumentProperties, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$DocumentProperties == null ? (class$org$jlibrary$core$properties$DocumentProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.DocumentProperties")) : class$org$jlibrary$core$properties$DocumentProperties, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$DocumentProperties == null ? (class$org$jlibrary$core$properties$DocumentProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.DocumentProperties")) : class$org$jlibrary$core$properties$DocumentProperties, qn));
        qn = new QName("urn:BeanService", "PropertyDef");
        call.registerTypeMapping(class$org$jlibrary$core$properties$PropertyDef == null ? (class$org$jlibrary$core$properties$PropertyDef = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.PropertyDef")) : class$org$jlibrary$core$properties$PropertyDef, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$PropertyDef == null ? (class$org$jlibrary$core$properties$PropertyDef = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.PropertyDef")) : class$org$jlibrary$core$properties$PropertyDef, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$PropertyDef == null ? (class$org$jlibrary$core$properties$PropertyDef = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.PropertyDef")) : class$org$jlibrary$core$properties$PropertyDef, qn));
        qn = new QName("urn:BeanService", "Credentials");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Credentials == null ? (class$org$jlibrary$core$entities$Credentials = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Credentials")) : class$org$jlibrary$core$entities$Credentials, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Credentials == null ? (class$org$jlibrary$core$entities$Credentials = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Credentials")) : class$org$jlibrary$core$entities$Credentials, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Credentials == null ? (class$org$jlibrary$core$entities$Credentials = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Credentials")) : class$org$jlibrary$core$entities$Credentials, qn));
        qn = new QName("urn:BeanService", "Ticket");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Ticket == null ? (class$org$jlibrary$core$entities$Ticket = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Ticket")) : class$org$jlibrary$core$entities$Ticket, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Ticket == null ? (class$org$jlibrary$core$entities$Ticket = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Ticket")) : class$org$jlibrary$core$entities$Ticket, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Ticket == null ? (class$org$jlibrary$core$entities$Ticket = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Ticket")) : class$org$jlibrary$core$entities$Ticket, qn));
        qn = new QName("urn:BeanService", "RepositoryInfo");
        call.registerTypeMapping(class$org$jlibrary$core$entities$RepositoryInfo == null ? (class$org$jlibrary$core$entities$RepositoryInfo = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.RepositoryInfo")) : class$org$jlibrary$core$entities$RepositoryInfo, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$RepositoryInfo == null ? (class$org$jlibrary$core$entities$RepositoryInfo = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.RepositoryInfo")) : class$org$jlibrary$core$entities$RepositoryInfo, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$RepositoryInfo == null ? (class$org$jlibrary$core$entities$RepositoryInfo = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.RepositoryInfo")) : class$org$jlibrary$core$entities$RepositoryInfo, qn));
        qn = new QName("urn:BeanService", "CategoryNode");
        call.registerTypeMapping(class$org$jlibrary$core$entities$CategoryNode == null ? (class$org$jlibrary$core$entities$CategoryNode = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.CategoryNode")) : class$org$jlibrary$core$entities$CategoryNode, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$CategoryNode == null ? (class$org$jlibrary$core$entities$CategoryNode = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.CategoryNode")) : class$org$jlibrary$core$entities$CategoryNode, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$CategoryNode == null ? (class$org$jlibrary$core$entities$CategoryNode = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.CategoryNode")) : class$org$jlibrary$core$entities$CategoryNode, qn));
        qn = new QName("urn:BeanService", "DocumentVersion");
        call.registerTypeMapping(class$org$jlibrary$core$entities$DocumentVersion == null ? (class$org$jlibrary$core$entities$DocumentVersion = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.DocumentVersion")) : class$org$jlibrary$core$entities$DocumentVersion, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$DocumentVersion == null ? (class$org$jlibrary$core$entities$DocumentVersion = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.DocumentVersion")) : class$org$jlibrary$core$entities$DocumentVersion, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$DocumentVersion == null ? (class$org$jlibrary$core$entities$DocumentVersion = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.DocumentVersion")) : class$org$jlibrary$core$entities$DocumentVersion, qn));
        qn = new QName("urn:BeanService", "Relation");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Relation == null ? (class$org$jlibrary$core$entities$Relation = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Relation")) : class$org$jlibrary$core$entities$Relation, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Relation == null ? (class$org$jlibrary$core$entities$Relation = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Relation")) : class$org$jlibrary$core$entities$Relation, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Relation == null ? (class$org$jlibrary$core$entities$Relation = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Relation")) : class$org$jlibrary$core$entities$Relation, qn));
        qn = new QName("urn:BeanService", "CategoryProperties");
        call.registerTypeMapping(class$org$jlibrary$core$properties$CategoryProperties == null ? (class$org$jlibrary$core$properties$CategoryProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.CategoryProperties")) : class$org$jlibrary$core$properties$CategoryProperties, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$CategoryProperties == null ? (class$org$jlibrary$core$properties$CategoryProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.CategoryProperties")) : class$org$jlibrary$core$properties$CategoryProperties, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$CategoryProperties == null ? (class$org$jlibrary$core$properties$CategoryProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.CategoryProperties")) : class$org$jlibrary$core$properties$CategoryProperties, qn));
        qn = new QName("urn:BeanService", "Lock");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Lock == null ? (class$org$jlibrary$core$entities$Lock = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Lock")) : class$org$jlibrary$core$entities$Lock, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Lock == null ? (class$org$jlibrary$core$entities$Lock = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Lock")) : class$org$jlibrary$core$entities$Lock, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Lock == null ? (class$org$jlibrary$core$entities$Lock = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Lock")) : class$org$jlibrary$core$entities$Lock, qn));
        qn = new QName("urn:BeanService", "Restriction");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Restriction == null ? (class$org$jlibrary$core$entities$Restriction = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Restriction")) : class$org$jlibrary$core$entities$Restriction, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Restriction == null ? (class$org$jlibrary$core$entities$Restriction = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Restriction")) : class$org$jlibrary$core$entities$Restriction, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Restriction == null ? (class$org$jlibrary$core$entities$Restriction = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.Restriction")) : class$org$jlibrary$core$entities$Restriction, qn));
        qn = new QName("urn:BeanService", "ResourceNode");
        call.registerTypeMapping(class$org$jlibrary$core$entities$ResourceNode == null ? (class$org$jlibrary$core$entities$ResourceNode = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.ResourceNode")) : class$org$jlibrary$core$entities$ResourceNode, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$ResourceNode == null ? (class$org$jlibrary$core$entities$ResourceNode = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.ResourceNode")) : class$org$jlibrary$core$entities$ResourceNode, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$ResourceNode == null ? (class$org$jlibrary$core$entities$ResourceNode = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.ResourceNode")) : class$org$jlibrary$core$entities$ResourceNode, qn));
        qn = new QName("urn:BeanService", "ResourceNodeProperties");
        call.registerTypeMapping(class$org$jlibrary$core$properties$ResourceNodeProperties == null ? (class$org$jlibrary$core$properties$ResourceNodeProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.ResourceNodeProperties")) : class$org$jlibrary$core$properties$ResourceNodeProperties, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$ResourceNodeProperties == null ? (class$org$jlibrary$core$properties$ResourceNodeProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.ResourceNodeProperties")) : class$org$jlibrary$core$properties$ResourceNodeProperties, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$ResourceNodeProperties == null ? (class$org$jlibrary$core$properties$ResourceNodeProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.ResourceNodeProperties")) : class$org$jlibrary$core$properties$ResourceNodeProperties, qn));
        qn = new QName("urn:BeanService", "DirectoryProperties");
        call.registerTypeMapping(class$org$jlibrary$core$properties$DirectoryProperties == null ? (class$org$jlibrary$core$properties$DirectoryProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.DirectoryProperties")) : class$org$jlibrary$core$properties$DirectoryProperties, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$DirectoryProperties == null ? (class$org$jlibrary$core$properties$DirectoryProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.DirectoryProperties")) : class$org$jlibrary$core$properties$DirectoryProperties, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$DirectoryProperties == null ? (class$org$jlibrary$core$properties$DirectoryProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.DirectoryProperties")) : class$org$jlibrary$core$properties$DirectoryProperties, qn));
        qn = new QName("urn:BeanService", "RepositoryProperties");
        call.registerTypeMapping(class$org$jlibrary$core$properties$RepositoryProperties == null ? (class$org$jlibrary$core$properties$RepositoryProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.RepositoryProperties")) : class$org$jlibrary$core$properties$RepositoryProperties, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$RepositoryProperties == null ? (class$org$jlibrary$core$properties$RepositoryProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.RepositoryProperties")) : class$org$jlibrary$core$properties$RepositoryProperties, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$RepositoryProperties == null ? (class$org$jlibrary$core$properties$RepositoryProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.RepositoryProperties")) : class$org$jlibrary$core$properties$RepositoryProperties, qn));
        qn = new QName("urn:BeanService", "RepositoryConfig");
        call.registerTypeMapping(class$org$jlibrary$core$entities$RepositoryConfig == null ? (class$org$jlibrary$core$entities$RepositoryConfig = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.RepositoryConfig")) : class$org$jlibrary$core$entities$RepositoryConfig, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$RepositoryConfig == null ? (class$org$jlibrary$core$entities$RepositoryConfig = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.RepositoryConfig")) : class$org$jlibrary$core$entities$RepositoryConfig, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$RepositoryConfig == null ? (class$org$jlibrary$core$entities$RepositoryConfig = AxisRepositoryDelegate.class$("org.jlibrary.core.entities.RepositoryConfig")) : class$org$jlibrary$core$entities$RepositoryConfig, qn));
        qn = new QName("urn:BeanService", "AuthorProperties");
        call.registerTypeMapping(class$org$jlibrary$core$properties$AuthorProperties == null ? (class$org$jlibrary$core$properties$AuthorProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.AuthorProperties")) : class$org$jlibrary$core$properties$AuthorProperties, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$AuthorProperties == null ? (class$org$jlibrary$core$properties$AuthorProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.AuthorProperties")) : class$org$jlibrary$core$properties$AuthorProperties, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$AuthorProperties == null ? (class$org$jlibrary$core$properties$AuthorProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.AuthorProperties")) : class$org$jlibrary$core$properties$AuthorProperties, qn));
        qn = new QName("urn:BeanService", "GenericProperties");
        call.registerTypeMapping(class$org$jlibrary$core$properties$GenericProperties == null ? (class$org$jlibrary$core$properties$GenericProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.GenericProperties")) : class$org$jlibrary$core$properties$GenericProperties, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$GenericProperties == null ? (class$org$jlibrary$core$properties$GenericProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.GenericProperties")) : class$org$jlibrary$core$properties$GenericProperties, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$GenericProperties == null ? (class$org$jlibrary$core$properties$GenericProperties = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.GenericProperties")) : class$org$jlibrary$core$properties$GenericProperties, qn));
        qn = new QName("urn:BeanService", "CustomPropertyDefinition");
        call.registerTypeMapping(class$org$jlibrary$core$properties$CustomPropertyDefinition == null ? (class$org$jlibrary$core$properties$CustomPropertyDefinition = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.CustomPropertyDefinition")) : class$org$jlibrary$core$properties$CustomPropertyDefinition, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$CustomPropertyDefinition == null ? (class$org$jlibrary$core$properties$CustomPropertyDefinition = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.CustomPropertyDefinition")) : class$org$jlibrary$core$properties$CustomPropertyDefinition, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$CustomPropertyDefinition == null ? (class$org$jlibrary$core$properties$CustomPropertyDefinition = AxisRepositoryDelegate.class$("org.jlibrary.core.properties.CustomPropertyDefinition")) : class$org$jlibrary$core$properties$CustomPropertyDefinition, qn));
    }

    private Lock lookForLock(Ticket ticket, String nodeId) {
        Node node = null;
        try {
            node = this.findNode(ticket, nodeId);
            return node.getLock();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean isPropertyRegistered(Ticket ticket, String propertyName) throws RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("isPropertyRegistered");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("propertyName", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_BOOLEAN);
            Boolean b = (Boolean)this.call.invoke(new Object[]{ticket, propertyName});
            return b;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public boolean isPropertyRegistered(Ticket ticket, String uri, String propertyName) throws RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("isPropertyRegistered");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("uri", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("propertyName", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_BOOLEAN);
            Boolean b = (Boolean)this.call.invoke(new Object[]{ticket, uri, propertyName});
            return b;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public void registerCustomProperty(Ticket ticket, CustomPropertyDefinition property) throws RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("registerCustomProperty");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("property", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, property});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public void unregisterCustomProperty(Ticket ticket, CustomPropertyDefinition property) throws RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("unregisterCustomProperty");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("property", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, property});
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public void exportRepository(Ticket ticket, OutputStream stream) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        byte[] content = this.exportRepository(ticket);
        try {
            IOUtils.write((byte[])content, (OutputStream)stream);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public void importRepository(Ticket ticket, String name, InputStream stream) throws RepositoryAlreadyExistsException, RepositoryException, SecurityException {
        byte[] content;
        try {
            content = IOUtils.toByteArray((InputStream)stream);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        this.importRepository(ticket, content, name);
    }

    public void loadDocumentContent(String docId, Ticket ticket, OutputStream stream) throws RepositoryException, SecurityException {
        byte[] content = this.loadDocumentContent(docId, ticket);
        try {
            IOUtils.write((byte[])content, (OutputStream)stream);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public void loadResourceNodeContent(Ticket ticket, String resourceId, OutputStream stream) throws RepositoryException, SecurityException {
        byte[] content = this.loadResourceNodeContent(ticket, resourceId);
        try {
            IOUtils.write((byte[])content, (OutputStream)stream);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public void loadVersionContent(Ticket ticket, String versionId, OutputStream stream) throws RepositoryException, SecurityException {
        byte[] content = this.loadVersionContent(ticket, versionId);
        try {
            IOUtils.write((byte[])content, (OutputStream)stream);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public Node updateContent(Ticket ticket, String docId, InputStream stream) throws SecurityException, RepositoryException {
        byte[] content;
        try {
            content = IOUtils.toByteArray((InputStream)stream);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        return this.updateContent(ticket, docId, content);
    }

    public Node updateContent(Ticket ticket, String docId, byte[] content) throws SecurityException, RepositoryException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("updateContent");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("docId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.addParameter("content", Constants.SOAP_BASE64BINARY, ParameterMode.IN);
            DataHandler handler = new DataHandler((DataSource)new ByteArrayDataSource(content, "application/octet-stream"));
            this.call.addAttachmentPart((Object)handler);
            this.call.setReturnType(Constants.XSD_ANY);
            Node node = (Node)this.call.invoke(new Object[]{ticket, docId, content});
            return node;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("SecurityException") != -1) {
                throw new SecurityException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("RepositoryAlreadyExistsException") != -1) {
                throw new RepositoryAlreadyExistsException();
            }
            throw new RepositoryException(fault.getFaultString());
        }
    }

    public String getJLibraryAPIVersion() throws UnknownMethodException {
        try {
            this.call.removeAllParameters();
            this.call.setTargetEndpointAddress(new URL(this.endpoint));
            this.call.setOperationName("getJLibraryAPIVersion");
            this.call.setReturnType(Constants.XSD_STRING);
            String version = (String)this.call.invoke(new Object[0]);
            return version;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("UnknownMethodException") != -1 || fault.getFaultString().indexOf("NoSuchMethodException") != -1) {
                throw new UnknownMethodException(fault.getFaultString());
            }
            throw new RuntimeException(fault.getFaultString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

