/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.axis.client;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.Constants;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.XMLStringProvider;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jlibrary.core.entities.Credentials;
import org.jlibrary.core.entities.Group;
import org.jlibrary.core.entities.Rol;
import org.jlibrary.core.entities.Ticket;
import org.jlibrary.core.entities.User;
import org.jlibrary.core.profiles.AxisServerProfile;
import org.jlibrary.core.properties.GroupProperties;
import org.jlibrary.core.properties.RolProperties;
import org.jlibrary.core.properties.UserProperties;
import org.jlibrary.core.repository.exception.RepositoryNotFoundException;
import org.jlibrary.core.security.SecurityException;
import org.jlibrary.core.security.SecurityService;
import org.jlibrary.core.security.exception.AuthenticationException;
import org.jlibrary.core.security.exception.GroupNotFoundException;
import org.jlibrary.core.security.exception.RoleNotFoundException;
import org.jlibrary.core.security.exception.UserAlreadyExistsException;
import org.jlibrary.core.security.exception.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxisSecurityDelegate
implements SecurityService {
    static Logger logger = LoggerFactory.getLogger((Class)(class$org$jlibrary$core$axis$client$AxisSecurityDelegate == null ? (class$org$jlibrary$core$axis$client$AxisSecurityDelegate = AxisSecurityDelegate.class$("org.jlibrary.core.axis.client.AxisSecurityDelegate")) : class$org$jlibrary$core$axis$client$AxisSecurityDelegate));
    private String endpoint;
    private Service axisService = new Service((EngineConfiguration)new XMLStringProvider("<deployment xmlns=\"http://xml.apache.org/axis/wsdd/\" xmlns:java=\"http://xml.apache.org/axis/wsdd/providers/java\">\n <transport name=\"local\" pivot=\"java:org.apache.axis.transport.local.LocalSender\"/>\n <transport name=\"java\" pivot=\"java:org.apache.axis.transport.http.JavaSender\"/>\n <transport name=\"http\" pivot=\"java:org.apache.axis.transport.http.CommonsHTTPSender\"/>\n</deployment>"));
    private Call call;
    static /* synthetic */ Class class$org$jlibrary$core$axis$client$AxisSecurityDelegate;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Repository;
    static /* synthetic */ Class class$org$jlibrary$core$entities$User;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Group;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Member;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Directory;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Document;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Node;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Favorite;
    static /* synthetic */ Class class$org$jlibrary$core$entities$DocumentMetaData;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Category;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Rol;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Bookmark;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Author;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Note;
    static /* synthetic */ Class class$org$jlibrary$core$properties$DocumentProperties;
    static /* synthetic */ Class class$org$jlibrary$core$properties$PropertyDef;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Credentials;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Ticket;
    static /* synthetic */ Class class$org$jlibrary$core$properties$UserProperties;
    static /* synthetic */ Class class$org$jlibrary$core$properties$GroupProperties;
    static /* synthetic */ Class class$org$jlibrary$core$properties$RolProperties;
    static /* synthetic */ Class class$org$jlibrary$core$entities$CategoryNode;
    static /* synthetic */ Class class$org$jlibrary$core$entities$Restriction;
    static /* synthetic */ Class class$org$jlibrary$core$entities$DocumentVersion;
    static /* synthetic */ Class class$org$jlibrary$core$entities$ResourceNode;
    static /* synthetic */ Class class$org$jlibrary$core$properties$ResourceNodeProperties;
    static /* synthetic */ Class class$org$jlibrary$core$properties$DirectoryProperties;
    static /* synthetic */ Class class$org$jlibrary$core$properties$RepositoryProperties;
    static /* synthetic */ Class class$org$jlibrary$core$entities$RepositoryConfig;
    static /* synthetic */ Class class$org$jlibrary$core$properties$AuthorProperties;
    static /* synthetic */ Class class$org$jlibrary$core$properties$GenericProperties;
    static /* synthetic */ Class class$org$jlibrary$core$properties$CustomPropertyDefinition;

    public AxisSecurityDelegate(AxisServerProfile profile) {
        AxisProperties.setProperty((String)"sendMultiRefs", (String)"FALSE");
        try {
            String location = profile.getLocation();
            location = StringUtils.replace((String)location, (String)"jlibrary://", (String)"http://");
            if (!location.endsWith("/")) {
                location = location + "/";
            }
            this.endpoint = location + "services/AxisSecurityService";
            this.call = (Call)this.axisService.createCall();
            this.call.setTargetEndpointAddress(this.endpoint);
            this.call.setMaintainSession(true);
        }
        catch (ServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.registerSerializers(this.call);
    }

    public User createUser(Ticket ticket, UserProperties userProperties) throws SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("createUser");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("userProperties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (User)this.call.invoke(new Object[]{ticket, userProperties});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public User updateUser(Ticket ticket, UserProperties userProperties) throws SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("updateUser");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("userProperties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (User)this.call.invoke(new Object[]{ticket, userProperties});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public User findUserByName(Ticket ticket, String name) throws SecurityException, UserNotFoundException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("findUserByName");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("name", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            User user = (User)this.call.invoke(new Object[]{ticket, name});
            return user;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public User findUserById(Ticket ticket, String userId) throws SecurityException, UserNotFoundException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("findUserById");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("userId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            User user = (User)this.call.invoke(new Object[]{ticket, userId});
            return user;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public Collection findAllUsers(Ticket ticket) throws SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("findAllUsers");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.SOAP_ARRAY);
            Object[] users = (Object[])this.call.invoke(new Object[]{ticket});
            ArrayList list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])users);
            return list;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public Collection findAllRoles(Ticket ticket) throws SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("findAllRoles");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.SOAP_ARRAY);
            Object[] roles = (Object[])this.call.invoke(new Object[]{ticket});
            ArrayList list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])roles);
            return list;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public Collection findAllGroups(Ticket ticket) throws SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("findAllGroups");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.SOAP_ARRAY);
            Object[] groups = (Object[])this.call.invoke(new Object[]{ticket});
            ArrayList list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])groups);
            return list;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public Rol createRol(Ticket ticket, RolProperties rolProperties) throws SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("createRol");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("rolProperties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Rol rol = (Rol)this.call.invoke(new Object[]{ticket, rolProperties});
            return rol;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public Rol updateRol(Ticket ticket, RolProperties rolProperties) throws SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("updateRol");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("rolProperties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (Rol)this.call.invoke(new Object[]{ticket, rolProperties});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public Rol findRol(Ticket ticket, String rolId) throws SecurityException, RoleNotFoundException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("findRol");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("rolId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Rol rol = (Rol)this.call.invoke(new Object[]{ticket, rolId});
            return rol;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public Group createGroup(Ticket ticket, GroupProperties groupProperties) throws SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("createGroup");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("groupProperties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (Group)this.call.invoke(new Object[]{ticket, groupProperties});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public Group updateGroup(Ticket ticket, GroupProperties groupProperties) throws SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("updateGroup");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("groupProperties", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            return (Group)this.call.invoke(new Object[]{ticket, groupProperties});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public Group findGroupById(Ticket ticket, String groupId) throws SecurityException, GroupNotFoundException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("findGroupById");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("groupId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Group group = (Group)this.call.invoke(new Object[]{ticket, groupId});
            return group;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public void removeUser(Ticket ticket, String userId) throws SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("removeUser");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("userId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, userId});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public void removeRol(Ticket ticket, String rolId) throws SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("removeRol");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("rolId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, rolId});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public void removeGroup(Ticket ticket, String groupId) throws SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("removeGroup");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("groupId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket, groupId});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public Ticket login(Credentials credentials, String name) throws UserNotFoundException, AuthenticationException, SecurityException, ConnectException, RepositoryNotFoundException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("login");
            this.call.addParameter("credentials", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("name", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Ticket ticket = (Ticket)this.call.invoke(new Object[]{credentials, name});
            return ticket;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            AxisFault fault = (AxisFault)e;
            if (fault.getFaultString().indexOf("ConnectException") != -1) {
                throw new ConnectException(fault.getFaultString());
            }
            if (fault.getFaultString().indexOf("RepositoryNotFoundException") != -1) {
                throw new RepositoryNotFoundException(fault.getFaultString());
            }
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public void disconnect(Ticket ticket) throws SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("disconnect");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.setReturnType(XMLType.AXIS_VOID);
            this.call.invoke(new Object[]{ticket});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw this.createSecurityException((AxisFault)e);
        }
    }

    public Collection findAllRestrictions(Ticket ticket, String nodeId) throws SecurityException {
        try {
            this.call.removeAllParameters();
            this.call.setOperationName("findAllRestrictions");
            this.call.addParameter("ticket", Constants.XSD_ANY, ParameterMode.IN);
            this.call.addParameter("nodeId", Constants.XSD_STRING, ParameterMode.IN);
            this.call.setReturnType(Constants.XSD_ANY);
            Object[] restrictions = (Object[])this.call.invoke(new Object[]{ticket, nodeId});
            ArrayList list = new ArrayList();
            CollectionUtils.addAll(list, (Object[])restrictions);
            return list;
        }
        catch (Exception e) {
            throw this.createSecurityException((AxisFault)e);
        }
    }

    private void registerSerializers(Call call) {
        QName qn = new QName("urn:BeanService", "Repository");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Repository == null ? (class$org$jlibrary$core$entities$Repository = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Repository")) : class$org$jlibrary$core$entities$Repository, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Repository == null ? (class$org$jlibrary$core$entities$Repository = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Repository")) : class$org$jlibrary$core$entities$Repository, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Repository == null ? (class$org$jlibrary$core$entities$Repository = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Repository")) : class$org$jlibrary$core$entities$Repository, qn));
        qn = new QName("urn:BeanService", "User");
        call.registerTypeMapping(class$org$jlibrary$core$entities$User == null ? (class$org$jlibrary$core$entities$User = AxisSecurityDelegate.class$("org.jlibrary.core.entities.User")) : class$org$jlibrary$core$entities$User, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$User == null ? (class$org$jlibrary$core$entities$User = AxisSecurityDelegate.class$("org.jlibrary.core.entities.User")) : class$org$jlibrary$core$entities$User, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$User == null ? (class$org$jlibrary$core$entities$User = AxisSecurityDelegate.class$("org.jlibrary.core.entities.User")) : class$org$jlibrary$core$entities$User, qn));
        qn = new QName("urn:BeanService", "Group");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Group == null ? (class$org$jlibrary$core$entities$Group = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Group")) : class$org$jlibrary$core$entities$Group, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Group == null ? (class$org$jlibrary$core$entities$Group = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Group")) : class$org$jlibrary$core$entities$Group, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Group == null ? (class$org$jlibrary$core$entities$Group = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Group")) : class$org$jlibrary$core$entities$Group, qn));
        qn = new QName("urn:BeanService", "Member");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Member == null ? (class$org$jlibrary$core$entities$Member = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Member")) : class$org$jlibrary$core$entities$Member, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Member == null ? (class$org$jlibrary$core$entities$Member = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Member")) : class$org$jlibrary$core$entities$Member, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Member == null ? (class$org$jlibrary$core$entities$Member = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Member")) : class$org$jlibrary$core$entities$Member, qn));
        qn = new QName("urn:BeanService", "Directory");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Directory == null ? (class$org$jlibrary$core$entities$Directory = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Directory")) : class$org$jlibrary$core$entities$Directory, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Directory == null ? (class$org$jlibrary$core$entities$Directory = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Directory")) : class$org$jlibrary$core$entities$Directory, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Directory == null ? (class$org$jlibrary$core$entities$Directory = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Directory")) : class$org$jlibrary$core$entities$Directory, qn));
        qn = new QName("urn:BeanService", "Document");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Document == null ? (class$org$jlibrary$core$entities$Document = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Document")) : class$org$jlibrary$core$entities$Document, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Document == null ? (class$org$jlibrary$core$entities$Document = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Document")) : class$org$jlibrary$core$entities$Document, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Document == null ? (class$org$jlibrary$core$entities$Document = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Document")) : class$org$jlibrary$core$entities$Document, qn));
        qn = new QName("urn:BeanService", "Node");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Node == null ? (class$org$jlibrary$core$entities$Node = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Node")) : class$org$jlibrary$core$entities$Node, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Node == null ? (class$org$jlibrary$core$entities$Node = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Node")) : class$org$jlibrary$core$entities$Node, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Node == null ? (class$org$jlibrary$core$entities$Node = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Node")) : class$org$jlibrary$core$entities$Node, qn));
        qn = new QName("urn:BeanService", "Favorite");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Favorite == null ? (class$org$jlibrary$core$entities$Favorite = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Favorite")) : class$org$jlibrary$core$entities$Favorite, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Favorite == null ? (class$org$jlibrary$core$entities$Favorite = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Favorite")) : class$org$jlibrary$core$entities$Favorite, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Favorite == null ? (class$org$jlibrary$core$entities$Favorite = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Favorite")) : class$org$jlibrary$core$entities$Favorite, qn));
        qn = new QName("urn:BeanService", "DocumentMetaData");
        call.registerTypeMapping(class$org$jlibrary$core$entities$DocumentMetaData == null ? (class$org$jlibrary$core$entities$DocumentMetaData = AxisSecurityDelegate.class$("org.jlibrary.core.entities.DocumentMetaData")) : class$org$jlibrary$core$entities$DocumentMetaData, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$DocumentMetaData == null ? (class$org$jlibrary$core$entities$DocumentMetaData = AxisSecurityDelegate.class$("org.jlibrary.core.entities.DocumentMetaData")) : class$org$jlibrary$core$entities$DocumentMetaData, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$DocumentMetaData == null ? (class$org$jlibrary$core$entities$DocumentMetaData = AxisSecurityDelegate.class$("org.jlibrary.core.entities.DocumentMetaData")) : class$org$jlibrary$core$entities$DocumentMetaData, qn));
        qn = new QName("urn:BeanService", "Category");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Category == null ? (class$org$jlibrary$core$entities$Category = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Category")) : class$org$jlibrary$core$entities$Category, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Category == null ? (class$org$jlibrary$core$entities$Category = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Category")) : class$org$jlibrary$core$entities$Category, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Category == null ? (class$org$jlibrary$core$entities$Category = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Category")) : class$org$jlibrary$core$entities$Category, qn));
        qn = new QName("urn:BeanService", "Rol");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Rol == null ? (class$org$jlibrary$core$entities$Rol = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Rol")) : class$org$jlibrary$core$entities$Rol, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Rol == null ? (class$org$jlibrary$core$entities$Rol = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Rol")) : class$org$jlibrary$core$entities$Rol, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Rol == null ? (class$org$jlibrary$core$entities$Rol = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Rol")) : class$org$jlibrary$core$entities$Rol, qn));
        qn = new QName("urn:BeanService", "Category");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Category == null ? (class$org$jlibrary$core$entities$Category = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Category")) : class$org$jlibrary$core$entities$Category, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Category == null ? (class$org$jlibrary$core$entities$Category = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Category")) : class$org$jlibrary$core$entities$Category, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Category == null ? (class$org$jlibrary$core$entities$Category = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Category")) : class$org$jlibrary$core$entities$Category, qn));
        qn = new QName("urn:BeanService", "Bookmark");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Bookmark == null ? (class$org$jlibrary$core$entities$Bookmark = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Bookmark")) : class$org$jlibrary$core$entities$Bookmark, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Bookmark == null ? (class$org$jlibrary$core$entities$Bookmark = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Bookmark")) : class$org$jlibrary$core$entities$Bookmark, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Bookmark == null ? (class$org$jlibrary$core$entities$Bookmark = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Bookmark")) : class$org$jlibrary$core$entities$Bookmark, qn));
        qn = new QName("urn:BeanService", "Author");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Author == null ? (class$org$jlibrary$core$entities$Author = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Author")) : class$org$jlibrary$core$entities$Author, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Author == null ? (class$org$jlibrary$core$entities$Author = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Author")) : class$org$jlibrary$core$entities$Author, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Author == null ? (class$org$jlibrary$core$entities$Author = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Author")) : class$org$jlibrary$core$entities$Author, qn));
        qn = new QName("urn:BeanService", "Note");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Note == null ? (class$org$jlibrary$core$entities$Note = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Note")) : class$org$jlibrary$core$entities$Note, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Note == null ? (class$org$jlibrary$core$entities$Note = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Note")) : class$org$jlibrary$core$entities$Note, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Note == null ? (class$org$jlibrary$core$entities$Note = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Note")) : class$org$jlibrary$core$entities$Note, qn));
        qn = new QName("urn:BeanService", "ResourceProperties");
        call.registerTypeMapping(class$org$jlibrary$core$properties$DocumentProperties == null ? (class$org$jlibrary$core$properties$DocumentProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.DocumentProperties")) : class$org$jlibrary$core$properties$DocumentProperties, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$DocumentProperties == null ? (class$org$jlibrary$core$properties$DocumentProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.DocumentProperties")) : class$org$jlibrary$core$properties$DocumentProperties, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$DocumentProperties == null ? (class$org$jlibrary$core$properties$DocumentProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.DocumentProperties")) : class$org$jlibrary$core$properties$DocumentProperties, qn));
        qn = new QName("urn:BeanService", "PropertyDef");
        call.registerTypeMapping(class$org$jlibrary$core$properties$PropertyDef == null ? (class$org$jlibrary$core$properties$PropertyDef = AxisSecurityDelegate.class$("org.jlibrary.core.properties.PropertyDef")) : class$org$jlibrary$core$properties$PropertyDef, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$PropertyDef == null ? (class$org$jlibrary$core$properties$PropertyDef = AxisSecurityDelegate.class$("org.jlibrary.core.properties.PropertyDef")) : class$org$jlibrary$core$properties$PropertyDef, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$PropertyDef == null ? (class$org$jlibrary$core$properties$PropertyDef = AxisSecurityDelegate.class$("org.jlibrary.core.properties.PropertyDef")) : class$org$jlibrary$core$properties$PropertyDef, qn));
        qn = new QName("urn:BeanService", "Credentials");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Credentials == null ? (class$org$jlibrary$core$entities$Credentials = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Credentials")) : class$org$jlibrary$core$entities$Credentials, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Credentials == null ? (class$org$jlibrary$core$entities$Credentials = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Credentials")) : class$org$jlibrary$core$entities$Credentials, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Credentials == null ? (class$org$jlibrary$core$entities$Credentials = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Credentials")) : class$org$jlibrary$core$entities$Credentials, qn));
        qn = new QName("urn:BeanService", "Ticket");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Ticket == null ? (class$org$jlibrary$core$entities$Ticket = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Ticket")) : class$org$jlibrary$core$entities$Ticket, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Ticket == null ? (class$org$jlibrary$core$entities$Ticket = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Ticket")) : class$org$jlibrary$core$entities$Ticket, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Ticket == null ? (class$org$jlibrary$core$entities$Ticket = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Ticket")) : class$org$jlibrary$core$entities$Ticket, qn));
        qn = new QName("urn:BeanService", "UserProperties");
        call.registerTypeMapping(class$org$jlibrary$core$properties$UserProperties == null ? (class$org$jlibrary$core$properties$UserProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.UserProperties")) : class$org$jlibrary$core$properties$UserProperties, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$UserProperties == null ? (class$org$jlibrary$core$properties$UserProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.UserProperties")) : class$org$jlibrary$core$properties$UserProperties, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$UserProperties == null ? (class$org$jlibrary$core$properties$UserProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.UserProperties")) : class$org$jlibrary$core$properties$UserProperties, qn));
        qn = new QName("urn:BeanService", "GroupProperties");
        call.registerTypeMapping(class$org$jlibrary$core$properties$GroupProperties == null ? (class$org$jlibrary$core$properties$GroupProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.GroupProperties")) : class$org$jlibrary$core$properties$GroupProperties, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$GroupProperties == null ? (class$org$jlibrary$core$properties$GroupProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.GroupProperties")) : class$org$jlibrary$core$properties$GroupProperties, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$GroupProperties == null ? (class$org$jlibrary$core$properties$GroupProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.GroupProperties")) : class$org$jlibrary$core$properties$GroupProperties, qn));
        qn = new QName("urn:BeanService", "RolProperties");
        call.registerTypeMapping(class$org$jlibrary$core$properties$RolProperties == null ? (class$org$jlibrary$core$properties$RolProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.RolProperties")) : class$org$jlibrary$core$properties$RolProperties, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$RolProperties == null ? (class$org$jlibrary$core$properties$RolProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.RolProperties")) : class$org$jlibrary$core$properties$RolProperties, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$RolProperties == null ? (class$org$jlibrary$core$properties$RolProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.RolProperties")) : class$org$jlibrary$core$properties$RolProperties, qn));
        qn = new QName("urn:BeanService", "CategoryNode");
        call.registerTypeMapping(class$org$jlibrary$core$entities$CategoryNode == null ? (class$org$jlibrary$core$entities$CategoryNode = AxisSecurityDelegate.class$("org.jlibrary.core.entities.CategoryNode")) : class$org$jlibrary$core$entities$CategoryNode, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$CategoryNode == null ? (class$org$jlibrary$core$entities$CategoryNode = AxisSecurityDelegate.class$("org.jlibrary.core.entities.CategoryNode")) : class$org$jlibrary$core$entities$CategoryNode, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$CategoryNode == null ? (class$org$jlibrary$core$entities$CategoryNode = AxisSecurityDelegate.class$("org.jlibrary.core.entities.CategoryNode")) : class$org$jlibrary$core$entities$CategoryNode, qn));
        qn = new QName("urn:BeanService", "Restriction");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Restriction == null ? (class$org$jlibrary$core$entities$Restriction = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Restriction")) : class$org$jlibrary$core$entities$Restriction, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$Restriction == null ? (class$org$jlibrary$core$entities$Restriction = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Restriction")) : class$org$jlibrary$core$entities$Restriction, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$Restriction == null ? (class$org$jlibrary$core$entities$Restriction = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Restriction")) : class$org$jlibrary$core$entities$Restriction, qn));
        qn = new QName("urn:BeanService", "DocumentVersion");
        call.registerTypeMapping(class$org$jlibrary$core$entities$DocumentVersion == null ? (class$org$jlibrary$core$entities$DocumentVersion = AxisSecurityDelegate.class$("org.jlibrary.core.entities.DocumentVersion")) : class$org$jlibrary$core$entities$DocumentVersion, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$DocumentVersion == null ? (class$org$jlibrary$core$entities$DocumentVersion = AxisSecurityDelegate.class$("org.jlibrary.core.entities.DocumentVersion")) : class$org$jlibrary$core$entities$DocumentVersion, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$DocumentVersion == null ? (class$org$jlibrary$core$entities$DocumentVersion = AxisSecurityDelegate.class$("org.jlibrary.core.entities.DocumentVersion")) : class$org$jlibrary$core$entities$DocumentVersion, qn));
        qn = new QName("urn:BeanService", "ResourceNode");
        call.registerTypeMapping(class$org$jlibrary$core$entities$Restriction == null ? (class$org$jlibrary$core$entities$Restriction = AxisSecurityDelegate.class$("org.jlibrary.core.entities.Restriction")) : class$org$jlibrary$core$entities$Restriction, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$ResourceNode == null ? (class$org$jlibrary$core$entities$ResourceNode = AxisSecurityDelegate.class$("org.jlibrary.core.entities.ResourceNode")) : class$org$jlibrary$core$entities$ResourceNode, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$ResourceNode == null ? (class$org$jlibrary$core$entities$ResourceNode = AxisSecurityDelegate.class$("org.jlibrary.core.entities.ResourceNode")) : class$org$jlibrary$core$entities$ResourceNode, qn));
        qn = new QName("urn:BeanService", "ResourceNodeProperties");
        call.registerTypeMapping(class$org$jlibrary$core$properties$ResourceNodeProperties == null ? (class$org$jlibrary$core$properties$ResourceNodeProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.ResourceNodeProperties")) : class$org$jlibrary$core$properties$ResourceNodeProperties, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$ResourceNodeProperties == null ? (class$org$jlibrary$core$properties$ResourceNodeProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.ResourceNodeProperties")) : class$org$jlibrary$core$properties$ResourceNodeProperties, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$ResourceNodeProperties == null ? (class$org$jlibrary$core$properties$ResourceNodeProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.ResourceNodeProperties")) : class$org$jlibrary$core$properties$ResourceNodeProperties, qn));
        qn = new QName("urn:BeanService", "DirectoryProperties");
        call.registerTypeMapping(class$org$jlibrary$core$properties$DirectoryProperties == null ? (class$org$jlibrary$core$properties$DirectoryProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.DirectoryProperties")) : class$org$jlibrary$core$properties$DirectoryProperties, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$DirectoryProperties == null ? (class$org$jlibrary$core$properties$DirectoryProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.DirectoryProperties")) : class$org$jlibrary$core$properties$DirectoryProperties, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$DirectoryProperties == null ? (class$org$jlibrary$core$properties$DirectoryProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.DirectoryProperties")) : class$org$jlibrary$core$properties$DirectoryProperties, qn));
        qn = new QName("urn:BeanService", "RepositoryProperties");
        call.registerTypeMapping(class$org$jlibrary$core$properties$RepositoryProperties == null ? (class$org$jlibrary$core$properties$RepositoryProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.RepositoryProperties")) : class$org$jlibrary$core$properties$RepositoryProperties, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$RepositoryProperties == null ? (class$org$jlibrary$core$properties$RepositoryProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.RepositoryProperties")) : class$org$jlibrary$core$properties$RepositoryProperties, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$RepositoryProperties == null ? (class$org$jlibrary$core$properties$RepositoryProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.RepositoryProperties")) : class$org$jlibrary$core$properties$RepositoryProperties, qn));
        qn = new QName("urn:BeanService", "RepositoryConfig");
        call.registerTypeMapping(class$org$jlibrary$core$entities$RepositoryConfig == null ? (class$org$jlibrary$core$entities$RepositoryConfig = AxisSecurityDelegate.class$("org.jlibrary.core.entities.RepositoryConfig")) : class$org$jlibrary$core$entities$RepositoryConfig, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$entities$RepositoryConfig == null ? (class$org$jlibrary$core$entities$RepositoryConfig = AxisSecurityDelegate.class$("org.jlibrary.core.entities.RepositoryConfig")) : class$org$jlibrary$core$entities$RepositoryConfig, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$entities$RepositoryConfig == null ? (class$org$jlibrary$core$entities$RepositoryConfig = AxisSecurityDelegate.class$("org.jlibrary.core.entities.RepositoryConfig")) : class$org$jlibrary$core$entities$RepositoryConfig, qn));
        qn = new QName("urn:BeanService", "AuthorProperties");
        call.registerTypeMapping(class$org$jlibrary$core$properties$AuthorProperties == null ? (class$org$jlibrary$core$properties$AuthorProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.AuthorProperties")) : class$org$jlibrary$core$properties$AuthorProperties, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$AuthorProperties == null ? (class$org$jlibrary$core$properties$AuthorProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.AuthorProperties")) : class$org$jlibrary$core$properties$AuthorProperties, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$AuthorProperties == null ? (class$org$jlibrary$core$properties$AuthorProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.AuthorProperties")) : class$org$jlibrary$core$properties$AuthorProperties, qn));
        qn = new QName("urn:BeanService", "GenericProperties");
        call.registerTypeMapping(class$org$jlibrary$core$properties$GenericProperties == null ? (class$org$jlibrary$core$properties$GenericProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.GenericProperties")) : class$org$jlibrary$core$properties$GenericProperties, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$GenericProperties == null ? (class$org$jlibrary$core$properties$GenericProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.GenericProperties")) : class$org$jlibrary$core$properties$GenericProperties, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$GenericProperties == null ? (class$org$jlibrary$core$properties$GenericProperties = AxisSecurityDelegate.class$("org.jlibrary.core.properties.GenericProperties")) : class$org$jlibrary$core$properties$GenericProperties, qn));
        qn = new QName("urn:BeanService", "CustomPropertyDefinition");
        call.registerTypeMapping(class$org$jlibrary$core$properties$CustomPropertyDefinition == null ? (class$org$jlibrary$core$properties$CustomPropertyDefinition = AxisSecurityDelegate.class$("org.jlibrary.core.properties.CustomPropertyDefinition")) : class$org$jlibrary$core$properties$CustomPropertyDefinition, qn, (SerializerFactory)new BeanSerializerFactory(class$org$jlibrary$core$properties$CustomPropertyDefinition == null ? (class$org$jlibrary$core$properties$CustomPropertyDefinition = AxisSecurityDelegate.class$("org.jlibrary.core.properties.CustomPropertyDefinition")) : class$org$jlibrary$core$properties$CustomPropertyDefinition, qn), (DeserializerFactory)new BeanDeserializerFactory(class$org$jlibrary$core$properties$CustomPropertyDefinition == null ? (class$org$jlibrary$core$properties$CustomPropertyDefinition = AxisSecurityDelegate.class$("org.jlibrary.core.properties.CustomPropertyDefinition")) : class$org$jlibrary$core$properties$CustomPropertyDefinition, qn));
    }

    public SecurityException createSecurityException(AxisFault fault) {
        if (fault.getFaultString().indexOf("UserNotFoundException") != -1) {
            return new UserNotFoundException();
        }
        if (fault.getFaultString().indexOf("UserAlreadyExistsException") != -1) {
            return new UserAlreadyExistsException();
        }
        if (fault.getFaultString().indexOf("RoleNotFoundException") != -1) {
            return new RoleNotFoundException();
        }
        if (fault.getFaultString().indexOf("GroupNotFoundException") != -1) {
            return new GroupNotFoundException();
        }
        if (fault.getFaultString().indexOf("AuthenticationException") != -1) {
            return new AuthenticationException(fault.getFaultString());
        }
        if (fault.getFaultString().contains("The user does not have enough permissions to perform this operation")) {
            return new SecurityException("The user does not have enough permissions to perform this operation");
        }
        return new SecurityException((Throwable)fault);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

