/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrary.core.factory;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.jlibrary.core.entities.ServerProfile;
import org.jlibrary.core.factory.JLibraryServiceFactory;
import org.jlibrary.core.factory.ServicesFactory;
import org.jlibrary.core.http.client.HTTPRepositoryDelegate;
import org.jlibrary.core.http.client.HTTPSearchDelegate;
import org.jlibrary.core.http.client.HTTPSecurityDelegate;
import org.jlibrary.core.profiles.HTTPServerProfile;
import org.jlibrary.core.repository.RepositoryService;
import org.jlibrary.core.search.SearchService;
import org.jlibrary.core.security.SecurityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteHTTPServicesFactory
implements ServicesFactory {
    static Logger logger = LoggerFactory.getLogger(RemoteHTTPServicesFactory.class);
    private static final String FILE_PROPERTIES_REMOTE = "http-remote.properties";
    private HTTPRepositoryDelegate repositoryService;
    private HTTPSecurityDelegate securityService;
    private HTTPSearchDelegate searchService;

    public RemoteHTTPServicesFactory(ServerProfile profile) {
        this.loadFactory(profile);
    }

    private void loadFactory(ServerProfile profile) {
        try {
            String propertiesFile = FILE_PROPERTIES_REMOTE;
            if (propertiesFile == null) {
                logger.error("Could not find properties for the given server profile");
                return;
            }
            InputStream is = JLibraryServiceFactory.class.getClassLoader().getResourceAsStream(propertiesFile);
            Properties factoryProperties = new Properties();
            factoryProperties.load(is);
            String repositoryService = factoryProperties.getProperty("RepositoryService");
            Class<?> repositoryServiceClass = Class.forName(repositoryService);
            Constructor<?> repositoryServiceConstructor = repositoryServiceClass.getConstructor(HTTPServerProfile.class);
            this.repositoryService = (HTTPRepositoryDelegate)repositoryServiceConstructor.newInstance(profile);
            String securityService = factoryProperties.getProperty("SecurityService");
            Class<?> securityServiceClass = Class.forName(securityService);
            Constructor<?> securityServiceConstructor = securityServiceClass.getConstructor(HTTPServerProfile.class);
            this.securityService = (HTTPSecurityDelegate)securityServiceConstructor.newInstance(profile);
            String searchService = factoryProperties.getProperty("SearchService");
            Class<?> searchServiceClass = Class.forName(searchService);
            Constructor<?> searchServiceConstructor = searchServiceClass.getConstructor(HTTPServerProfile.class);
            this.searchService = (HTTPSearchDelegate)searchServiceConstructor.newInstance(profile);
            is.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }
}

